/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg;

import com.google.protobuf.InvalidProtocolBufferException;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.TbMsgTransactionData;
import org.thingsboard.server.common.msg.gen.MsgProtos;

public final class TbMsg
implements Serializable {
    private final UUID id;
    private final String type;
    private final EntityId originator;
    private final TbMsgMetaData metaData;
    private final TbMsgDataType dataType;
    private final String data;
    private final TbMsgTransactionData transactionData;
    private final RuleChainId ruleChainId;
    private final RuleNodeId ruleNodeId;
    private final long clusterPartition;

    public static TbMsg createNewMsg(UUID id, String type, EntityId originator, TbMsgMetaData metaData, String data) {
        return new TbMsg(id, type, originator, metaData, data, null, null, 0L);
    }

    public TbMsg(UUID id, String type, EntityId originator, TbMsgMetaData metaData, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId, long clusterPartition) {
        this.id = id;
        this.type = type;
        this.originator = originator;
        this.metaData = metaData;
        this.data = data;
        this.dataType = TbMsgDataType.JSON;
        this.transactionData = new TbMsgTransactionData(id, originator);
        this.ruleChainId = ruleChainId;
        this.ruleNodeId = ruleNodeId;
        this.clusterPartition = clusterPartition;
    }

    public TbMsg(UUID id, String type, EntityId originator, TbMsgMetaData metaData, TbMsgDataType dataType, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId, long clusterPartition) {
        this(id, type, originator, metaData, dataType, data, new TbMsgTransactionData(id, originator), ruleChainId, ruleNodeId, clusterPartition);
    }

    public static byte[] toByteArray(TbMsg msg) {
        TbMsgTransactionData transactionData;
        MsgProtos.TbMsgProto.Builder builder = MsgProtos.TbMsgProto.newBuilder();
        builder.setId(msg.getId().toString());
        builder.setType(msg.getType());
        builder.setEntityType(msg.getOriginator().getEntityType().name());
        builder.setEntityIdMSB(msg.getOriginator().getId().getMostSignificantBits());
        builder.setEntityIdLSB(msg.getOriginator().getId().getLeastSignificantBits());
        if (msg.getRuleChainId() != null) {
            builder.setRuleChainIdMSB(msg.getRuleChainId().getId().getMostSignificantBits());
            builder.setRuleChainIdLSB(msg.getRuleChainId().getId().getLeastSignificantBits());
        }
        if (msg.getRuleNodeId() != null) {
            builder.setRuleNodeIdMSB(msg.getRuleNodeId().getId().getMostSignificantBits());
            builder.setRuleNodeIdLSB(msg.getRuleNodeId().getId().getLeastSignificantBits());
        }
        if (msg.getMetaData() != null) {
            builder.setMetaData(MsgProtos.TbMsgMetaDataProto.newBuilder().putAllData(msg.getMetaData().getData()).build());
        }
        if ((transactionData = msg.getTransactionData()) != null) {
            MsgProtos.TbMsgTransactionDataProto.Builder transactionBuilder = MsgProtos.TbMsgTransactionDataProto.newBuilder();
            transactionBuilder.setId(transactionData.getTransactionId().toString());
            transactionBuilder.setEntityType(transactionData.getOriginatorId().getEntityType().name());
            transactionBuilder.setEntityIdMSB(transactionData.getOriginatorId().getId().getMostSignificantBits());
            transactionBuilder.setEntityIdLSB(transactionData.getOriginatorId().getId().getLeastSignificantBits());
            builder.setTransactionData(transactionBuilder.build());
        }
        builder.setDataType(msg.getDataType().ordinal());
        builder.setData(msg.getData());
        return builder.build().toByteArray();
    }

    public static ByteBuffer toBytes(TbMsg msg) {
        return ByteBuffer.wrap(TbMsg.toByteArray(msg));
    }

    public static TbMsg fromBytes(byte[] data) {
        return TbMsg.fromBytes(ByteBuffer.wrap(data));
    }

    public static TbMsg fromBytes(ByteBuffer buffer) {
        try {
            MsgProtos.TbMsgProto proto = MsgProtos.TbMsgProto.parseFrom(buffer.array());
            TbMsgMetaData metaData = new TbMsgMetaData(proto.getMetaData().getDataMap());
            EntityId transactionEntityId = EntityIdFactory.getByTypeAndUuid((String)proto.getTransactionData().getEntityType(), (UUID)new UUID(proto.getTransactionData().getEntityIdMSB(), proto.getTransactionData().getEntityIdLSB()));
            TbMsgTransactionData transactionData = new TbMsgTransactionData(UUID.fromString(proto.getTransactionData().getId()), transactionEntityId);
            EntityId entityId = EntityIdFactory.getByTypeAndUuid((String)proto.getEntityType(), (UUID)new UUID(proto.getEntityIdMSB(), proto.getEntityIdLSB()));
            RuleChainId ruleChainId = new RuleChainId(new UUID(proto.getRuleChainIdMSB(), proto.getRuleChainIdLSB()));
            RuleNodeId ruleNodeId = null;
            if (proto.getRuleNodeIdMSB() != 0L && proto.getRuleNodeIdLSB() != 0L) {
                ruleNodeId = new RuleNodeId(new UUID(proto.getRuleNodeIdMSB(), proto.getRuleNodeIdLSB()));
            }
            TbMsgDataType dataType = TbMsgDataType.values()[proto.getDataType()];
            return new TbMsg(UUID.fromString(proto.getId()), proto.getType(), entityId, metaData, dataType, proto.getData(), transactionData, ruleChainId, ruleNodeId, proto.getClusterPartition());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Could not parse protobuf for TbMsg", e);
        }
    }

    public TbMsg copy(UUID newId, RuleChainId ruleChainId, RuleNodeId ruleNodeId, long clusterPartition) {
        return new TbMsg(newId, this.type, this.originator, this.metaData.copy(), this.dataType, this.data, this.transactionData, ruleChainId, ruleNodeId, clusterPartition);
    }

    public UUID getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public EntityId getOriginator() {
        return this.originator;
    }

    public TbMsgMetaData getMetaData() {
        return this.metaData;
    }

    public TbMsgDataType getDataType() {
        return this.dataType;
    }

    public String getData() {
        return this.data;
    }

    public TbMsgTransactionData getTransactionData() {
        return this.transactionData;
    }

    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    public RuleNodeId getRuleNodeId() {
        return this.ruleNodeId;
    }

    public long getClusterPartition() {
        return this.clusterPartition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbMsg)) {
            return false;
        }
        TbMsg other = (TbMsg)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        EntityId this$originator = this.getOriginator();
        EntityId other$originator = other.getOriginator();
        if (this$originator == null ? other$originator != null : !this$originator.equals(other$originator)) {
            return false;
        }
        TbMsgMetaData this$metaData = this.getMetaData();
        TbMsgMetaData other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        TbMsgDataType this$dataType = this.getDataType();
        TbMsgDataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        TbMsgTransactionData this$transactionData = this.getTransactionData();
        TbMsgTransactionData other$transactionData = other.getTransactionData();
        if (this$transactionData == null ? other$transactionData != null : !((Object)this$transactionData).equals(other$transactionData)) {
            return false;
        }
        RuleChainId this$ruleChainId = this.getRuleChainId();
        RuleChainId other$ruleChainId = other.getRuleChainId();
        if (this$ruleChainId == null ? other$ruleChainId != null : !this$ruleChainId.equals(other$ruleChainId)) {
            return false;
        }
        RuleNodeId this$ruleNodeId = this.getRuleNodeId();
        RuleNodeId other$ruleNodeId = other.getRuleNodeId();
        if (this$ruleNodeId == null ? other$ruleNodeId != null : !this$ruleNodeId.equals(other$ruleNodeId)) {
            return false;
        }
        return this.getClusterPartition() == other.getClusterPartition();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        EntityId $originator = this.getOriginator();
        result = result * 59 + ($originator == null ? 43 : $originator.hashCode());
        TbMsgMetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        TbMsgDataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        TbMsgTransactionData $transactionData = this.getTransactionData();
        result = result * 59 + ($transactionData == null ? 43 : ((Object)$transactionData).hashCode());
        RuleChainId $ruleChainId = this.getRuleChainId();
        result = result * 59 + ($ruleChainId == null ? 43 : $ruleChainId.hashCode());
        RuleNodeId $ruleNodeId = this.getRuleNodeId();
        result = result * 59 + ($ruleNodeId == null ? 43 : $ruleNodeId.hashCode());
        long $clusterPartition = this.getClusterPartition();
        result = result * 59 + (int)($clusterPartition >>> 32 ^ $clusterPartition);
        return result;
    }

    public String toString() {
        return "TbMsg(id=" + this.getId() + ", type=" + this.getType() + ", originator=" + this.getOriginator() + ", metaData=" + this.getMetaData() + ", dataType=" + (Object)((Object)this.getDataType()) + ", data=" + this.getData() + ", transactionData=" + this.getTransactionData() + ", ruleChainId=" + this.getRuleChainId() + ", ruleNodeId=" + this.getRuleNodeId() + ", clusterPartition=" + this.getClusterPartition() + ")";
    }

    @ConstructorProperties(value={"id", "type", "originator", "metaData", "dataType", "data", "transactionData", "ruleChainId", "ruleNodeId", "clusterPartition"})
    public TbMsg(UUID id, String type, EntityId originator, TbMsgMetaData metaData, TbMsgDataType dataType, String data, TbMsgTransactionData transactionData, RuleChainId ruleChainId, RuleNodeId ruleNodeId, long clusterPartition) {
        this.id = id;
        this.type = type;
        this.originator = originator;
        this.metaData = metaData;
        this.dataType = dataType;
        this.data = data;
        this.transactionData = transactionData;
        this.ruleChainId = ruleChainId;
        this.ruleNodeId = ruleNodeId;
        this.clusterPartition = clusterPartition;
    }
}

