/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg;

import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionUtil {
    private static final Logger log = LoggerFactory.getLogger(EncryptionUtil.class);

    private EncryptionUtil() {
    }

    public static String trimNewLines(String input) {
        return input.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", "").replaceAll("\n", "").replaceAll("\r", "");
    }

    public static String getSha3Hash(String data) {
        String trimmedData = EncryptionUtil.trimNewLines(data);
        byte[] dataBytes = trimmedData.getBytes();
        SHA3Digest md = new SHA3Digest(256);
        md.reset();
        md.update(dataBytes, 0, dataBytes.length);
        byte[] hashedBytes = new byte[32];
        md.doFinal(hashedBytes, 0);
        String sha3Hash = ByteUtils.toHexString((byte[])hashedBytes);
        return sha3Hash;
    }
}

