/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.js.api;

public class UplinkConverterScriptFactory {
    private static final String JS_HELPERS_PREFIX_TEMPLATE = "load('classpath:js/converter-helpers.js'); ";
    private static final String JS_WRAPPER_PREFIX_TEMPLATE = "function %s(bytesBase64, metadataStr) {     var payload = convertBytesBase64(bytesBase64);     var metadata = JSON.parse(metadataStr);     return JSON.stringify(Decoder(payload, metadata));    function Decoder(payload, metadata) {";
    private static final String JS_WRAPPER_SUFFIX = "}    function convertBytesBase64(bytesBase64) {\n       var binary_string = atob(bytesBase64);\n       var len = binary_string.length;\n       var payload = [];\n       for (var i = 0; i < len; i++) {\n           payload.push(binary_string.charCodeAt(i));\n       }\n       return payload;\n    }\n\n}";

    public static String generateUplinkConverterScript(String functionName, String scriptBody, boolean isLocal) {
        String jsWrapperPrefix = String.format(JS_WRAPPER_PREFIX_TEMPLATE, functionName);
        String result = jsWrapperPrefix + scriptBody + JS_WRAPPER_SUFFIX;
        if (isLocal) {
            result = JS_HELPERS_PREFIX_TEMPLATE + result;
        }
        return result;
    }
}

