/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.js.api;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.thingsboard.js.api.AbstractNashornJsInvokeService;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.common.stats.TbApiUsageStateClient;

@ConditionalOnProperty(prefix="js", value={"evaluator"}, havingValue="local", matchIfMissing=true)
@Service
public class NashornJsInvokeService
extends AbstractNashornJsInvokeService {
    private static final Logger log = LoggerFactory.getLogger(NashornJsInvokeService.class);
    @Value(value="${js.local.use_js_sandbox}")
    private boolean useJsSandbox;
    @Value(value="${js.local.monitor_thread_pool_size}")
    private int monitorThreadPoolSize;
    @Value(value="${js.local.max_cpu_time}")
    private long maxCpuTime;
    @Value(value="${js.local.max_errors}")
    private int maxErrors;
    @Value(value="${js.local.max_black_list_duration_sec:60}")
    private int maxBlackListDurationSec;

    public NashornJsInvokeService(Optional<TbApiUsageStateClient> apiUsageStateClient, Optional<TbApiUsageReportClient> apiUsageReportClient) {
        super(apiUsageStateClient, apiUsageReportClient);
    }

    @Override
    protected boolean useJsSandbox() {
        return this.useJsSandbox;
    }

    @Override
    protected int getMonitorThreadPoolSize() {
        return this.monitorThreadPoolSize;
    }

    @Override
    protected long getMaxCpuTime() {
        return this.maxCpuTime;
    }

    @Override
    protected int getMaxErrors() {
        return this.maxErrors;
    }

    @Override
    protected long getMaxBlacklistDuration() {
        return TimeUnit.SECONDS.toMillis(this.maxBlackListDurationSec);
    }
}

