/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.js.api;

import com.google.common.util.concurrent.FutureCallback;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class JsStatCallback<T>
implements FutureCallback<T> {
    private final AtomicInteger jsSuccessMsgs;
    private final AtomicInteger jsTimeoutMsgs;
    private final AtomicInteger jsFailedMsgs;

    public void onSuccess(T result) {
        this.jsSuccessMsgs.incrementAndGet();
    }

    public void onFailure(Throwable t) {
        if (t instanceof TimeoutException || t.getCause() != null && t.getCause() instanceof TimeoutException) {
            this.jsTimeoutMsgs.incrementAndGet();
        } else {
            this.jsFailedMsgs.incrementAndGet();
        }
    }

    @ConstructorProperties(value={"jsSuccessMsgs", "jsTimeoutMsgs", "jsFailedMsgs"})
    public JsStatCallback(AtomicInteger jsSuccessMsgs, AtomicInteger jsTimeoutMsgs, AtomicInteger jsFailedMsgs) {
        this.jsSuccessMsgs = jsSuccessMsgs;
        this.jsTimeoutMsgs = jsTimeoutMsgs;
        this.jsFailedMsgs = jsFailedMsgs;
    }
}

