/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.js.api;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import delight.nashornsandbox.NashornSandbox;
import delight.nashornsandbox.NashornSandboxes;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.js.api.AbstractJsInvokeService;
import org.thingsboard.js.api.JsStatCallback;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.common.stats.TbApiUsageStateClient;

public abstract class AbstractNashornJsInvokeService
extends AbstractJsInvokeService {
    private static final Logger log = LoggerFactory.getLogger(AbstractNashornJsInvokeService.class);
    private NashornSandbox sandbox;
    private ScriptEngine engine;
    private ExecutorService monitorExecutorService;
    private ListeningExecutorService jsExecutor;
    private final AtomicInteger jsPushedMsgs = new AtomicInteger(0);
    private final AtomicInteger jsInvokeMsgs = new AtomicInteger(0);
    private final AtomicInteger jsEvalMsgs = new AtomicInteger(0);
    private final AtomicInteger jsFailedMsgs = new AtomicInteger(0);
    private final AtomicInteger jsTimeoutMsgs = new AtomicInteger(0);
    private final FutureCallback<UUID> evalCallback = new JsStatCallback<UUID>(this.jsEvalMsgs, this.jsTimeoutMsgs, this.jsFailedMsgs);
    private final FutureCallback<Object> invokeCallback = new JsStatCallback<Object>(this.jsInvokeMsgs, this.jsTimeoutMsgs, this.jsFailedMsgs);
    private final ReentrantLock evalLock = new ReentrantLock();
    @Value(value="${js.local.max_requests_timeout:0}")
    private long maxRequestsTimeout;
    @Value(value="${js.local.stats.enabled:true}")
    private boolean statsEnabled;
    @Value(value="${js.local.js_thread_pool_size:50}")
    private int jsExecutorThreadPoolSize;

    public AbstractNashornJsInvokeService(Optional<TbApiUsageStateClient> apiUsageStateClient, Optional<TbApiUsageReportClient> apiUsageReportClient) {
        super(apiUsageStateClient, apiUsageReportClient);
    }

    @Scheduled(fixedDelayString="${js.local.stats.print_interval_ms:10000}")
    public void printStats() {
        if (this.statsEnabled) {
            int pushedMsgs = this.jsPushedMsgs.getAndSet(0);
            int invokeMsgs = this.jsInvokeMsgs.getAndSet(0);
            int evalMsgs = this.jsEvalMsgs.getAndSet(0);
            int failed = this.jsFailedMsgs.getAndSet(0);
            int timedOut = this.jsTimeoutMsgs.getAndSet(0);
            if (pushedMsgs > 0 || invokeMsgs > 0 || evalMsgs > 0 || failed > 0 || timedOut > 0) {
                log.info("Nashorn JS Invoke Stats: pushed [{}] received [{}] invoke [{}] eval [{}] failed [{}] timedOut [{}]", new Object[]{pushedMsgs, invokeMsgs + evalMsgs, invokeMsgs, evalMsgs, failed, timedOut});
            }
        }
    }

    @PostConstruct
    public void init() {
        super.init(this.maxRequestsTimeout);
        this.jsExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newWorkStealingPool(this.jsExecutorThreadPoolSize));
        if (this.useJsSandbox()) {
            this.sandbox = NashornSandboxes.create();
            this.monitorExecutorService = ThingsBoardExecutors.newWorkStealingPool((int)this.getMonitorThreadPoolSize(), (String)"nashorn-js-monitor");
            this.sandbox.setExecutor(this.monitorExecutorService);
            this.sandbox.setMaxCPUTime(this.getMaxCpuTime());
            this.sandbox.allowNoBraces(false);
            this.sandbox.allowLoadFunctions(true);
            this.sandbox.setMaxPreparedStatements(30);
        } else {
            ScriptEngineManager factory = new ScriptEngineManager();
            this.engine = factory.getEngineByName("nashorn");
        }
    }

    @Override
    @PreDestroy
    public void stop() {
        super.stop();
        if (this.monitorExecutorService != null) {
            this.monitorExecutorService.shutdownNow();
        }
    }

    protected abstract boolean useJsSandbox();

    protected abstract int getMonitorThreadPoolSize();

    protected abstract long getMaxCpuTime();

    @Override
    protected boolean isLocal() {
        return true;
    }

    @Override
    protected ListenableFuture<UUID> doEval(UUID scriptId, String functionName, String jsScript) {
        this.jsPushedMsgs.incrementAndGet();
        ListenableFuture result = this.jsExecutor.submit(() -> {
            try {
                this.evalLock.lock();
                try {
                    if (this.useJsSandbox()) {
                        this.sandbox.eval(jsScript);
                    } else {
                        this.engine.eval(jsScript);
                    }
                }
                finally {
                    this.evalLock.unlock();
                }
                this.scriptIdToNameMap.put(scriptId, functionName);
                return scriptId;
            }
            catch (Exception e) {
                log.debug("Failed to compile JS script: {}", (Object)e.getMessage(), (Object)e);
                throw new ExecutionException(e);
            }
        });
        if (this.maxRequestsTimeout > 0L) {
            result = Futures.withTimeout((ListenableFuture)result, (long)this.maxRequestsTimeout, (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.timeoutExecutorService);
        }
        Futures.addCallback((ListenableFuture)result, this.evalCallback, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    @Override
    protected ListenableFuture<Object> doInvokeFunction(UUID scriptId, String functionName, Object[] args) {
        this.jsPushedMsgs.incrementAndGet();
        ListenableFuture result = this.jsExecutor.submit(() -> {
            try {
                if (this.useJsSandbox()) {
                    return this.sandbox.getSandboxedInvocable().invokeFunction(functionName, args);
                }
                return ((Invocable)((Object)this.engine)).invokeFunction(functionName, args);
            }
            catch (Exception e) {
                this.onScriptExecutionError(scriptId, e, functionName);
                throw new ExecutionException(e);
            }
        });
        if (this.maxRequestsTimeout > 0L) {
            result = Futures.withTimeout((ListenableFuture)result, (long)this.maxRequestsTimeout, (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.timeoutExecutorService);
        }
        Futures.addCallback((ListenableFuture)result, this.invokeCallback, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    @Override
    protected void doRelease(UUID scriptId, String functionName) throws ScriptException {
        if (this.useJsSandbox()) {
            this.sandbox.eval(functionName + " = undefined;");
        } else {
            this.engine.eval(functionName + " = undefined;");
        }
    }
}

