/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.js.api;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.js.api.AttributesScriptFactory;
import org.thingsboard.js.api.DownlinkConverterScriptFactory;
import org.thingsboard.js.api.JsInvokeService;
import org.thingsboard.js.api.JsScriptType;
import org.thingsboard.js.api.RuleNodeScriptFactory;
import org.thingsboard.js.api.UplinkConverterScriptFactory;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.common.stats.TbApiUsageStateClient;

public abstract class AbstractJsInvokeService
implements JsInvokeService {
    private static final Logger log = LoggerFactory.getLogger(AbstractJsInvokeService.class);
    private final Optional<TbApiUsageStateClient> apiUsageStateClient;
    private final Optional<TbApiUsageReportClient> apiUsageReportClient;
    protected ScheduledExecutorService timeoutExecutorService;
    protected Map<UUID, String> scriptIdToNameMap = new ConcurrentHashMap<UUID, String>();
    protected Map<UUID, DisableListInfo> disabledFunctions = new ConcurrentHashMap<UUID, DisableListInfo>();

    protected AbstractJsInvokeService(Optional<TbApiUsageStateClient> apiUsageStateClient, Optional<TbApiUsageReportClient> apiUsageReportClient) {
        this.apiUsageStateClient = apiUsageStateClient;
        this.apiUsageReportClient = apiUsageReportClient;
    }

    public void init(long maxRequestsTimeout) {
        if (maxRequestsTimeout > 0L) {
            this.timeoutExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"nashorn-js-timeout"));
        }
    }

    public void stop() {
        if (this.timeoutExecutorService != null) {
            this.timeoutExecutorService.shutdownNow();
        }
    }

    @Override
    public ListenableFuture<UUID> eval(TenantId tenantId, JsScriptType scriptType, String scriptBody, String ... argNames) {
        if (!this.apiUsageStateClient.isPresent() || this.apiUsageStateClient.get().getApiUsageState(tenantId).isJsExecEnabled()) {
            UUID scriptId = UUID.randomUUID();
            String functionName = "invokeInternal_" + scriptId.toString().replace('-', '_');
            String jsScript = this.generateJsScript(scriptType, functionName, scriptBody, argNames);
            return this.doEval(scriptId, functionName, jsScript);
        }
        return Futures.immediateFailedFuture((Throwable)new RuntimeException("JS Execution is disabled due to API limits!"));
    }

    @Override
    public ListenableFuture<Object> invokeFunction(TenantId tenantId, CustomerId customerId, UUID scriptId, Object ... args) {
        if (!this.apiUsageStateClient.isPresent() || this.apiUsageStateClient.get().getApiUsageState(tenantId).isJsExecEnabled()) {
            String functionName = this.scriptIdToNameMap.get(scriptId);
            if (functionName == null) {
                return Futures.immediateFailedFuture((Throwable)new RuntimeException("No compiled script found for scriptId: [" + scriptId + "]!"));
            }
            if (!this.isDisabled(scriptId)) {
                this.apiUsageReportClient.ifPresent(client -> client.report(tenantId, customerId, ApiUsageRecordKey.JS_EXEC_COUNT, 1L));
                return this.doInvokeFunction(scriptId, functionName, args);
            }
            String message = "Script invocation is blocked due to maximum error count " + this.getMaxErrors() + ", scriptId " + scriptId + "!";
            log.warn(message);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(message));
        }
        return Futures.immediateFailedFuture((Throwable)new RuntimeException("JS Execution is disabled due to API limits!"));
    }

    @Override
    public ListenableFuture<Void> release(UUID scriptId) {
        String functionName = this.scriptIdToNameMap.get(scriptId);
        if (functionName != null) {
            try {
                this.scriptIdToNameMap.remove(scriptId);
                this.disabledFunctions.remove(scriptId);
                this.doRelease(scriptId, functionName);
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        return Futures.immediateFuture(null);
    }

    protected abstract ListenableFuture<UUID> doEval(UUID var1, String var2, String var3);

    protected abstract ListenableFuture<Object> doInvokeFunction(UUID var1, String var2, Object[] var3);

    protected abstract void doRelease(UUID var1, String var2) throws Exception;

    protected abstract int getMaxErrors();

    protected abstract boolean isLocal();

    protected abstract long getMaxBlacklistDuration();

    protected void onScriptExecutionError(UUID scriptId, Throwable t, String scriptBody) {
        DisableListInfo disableListInfo = this.disabledFunctions.computeIfAbsent(scriptId, key -> new DisableListInfo());
        log.warn("Script has exception and will increment counter {} on disabledFunctions for id {}, exception {}, cause {}, scriptBody {}", new Object[]{disableListInfo.get(), scriptId, t, t.getCause(), scriptBody});
        disableListInfo.incrementAndGet();
    }

    private String generateJsScript(JsScriptType scriptType, String functionName, String scriptBody, String ... argNames) {
        switch (scriptType) {
            case RULE_NODE_SCRIPT: {
                return RuleNodeScriptFactory.generateRuleNodeScript(functionName, scriptBody, argNames);
            }
            case ATTRIBUTES_SCRIPT: {
                return AttributesScriptFactory.generateAttributesScript(functionName, scriptBody);
            }
            case UPLINK_CONVERTER_SCRIPT: {
                return UplinkConverterScriptFactory.generateUplinkConverterScript(functionName, scriptBody, this.isLocal());
            }
            case DOWNLINK_CONVERTER_SCRIPT: {
                return DownlinkConverterScriptFactory.generateDownlinkConverterScript(functionName, scriptBody, this.isLocal());
            }
        }
        throw new RuntimeException("No script factory implemented for scriptType: " + scriptType);
    }

    private boolean isDisabled(UUID scriptId) {
        DisableListInfo errorCount = this.disabledFunctions.get(scriptId);
        if (errorCount != null) {
            if (errorCount.getExpirationTime() <= System.currentTimeMillis()) {
                this.disabledFunctions.remove(scriptId);
                return false;
            }
            return errorCount.get() >= this.getMaxErrors();
        }
        return false;
    }

    private class DisableListInfo {
        private final AtomicInteger counter = new AtomicInteger(0);
        private long expirationTime;

        private DisableListInfo() {
        }

        public int get() {
            return this.counter.get();
        }

        public int incrementAndGet() {
            int result = this.counter.incrementAndGet();
            this.expirationTime = System.currentTimeMillis() + AbstractJsInvokeService.this.getMaxBlacklistDuration();
            return result;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }
    }
}

