/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.storage;

import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Objects;

class EventStorageReaderPointer {
    private File file;
    private int line;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventStorageReaderPointer that = (EventStorageReaderPointer)o;
        return this.line == that.line && Objects.equals(this.file.getName(), that.file.getName());
    }

    public EventStorageReaderPointer copy() {
        return new EventStorageReaderPointer(this.file, this.line);
    }

    public int hashCode() {
        return Objects.hash(this.file.getName(), this.line);
    }

    public String toString() {
        return "EventStorageReaderPointer(file=" + String.valueOf(this.getFile()) + ", line=" + this.getLine() + ")";
    }

    @ConstructorProperties(value={"file", "line"})
    public EventStorageReaderPointer(File file, int line) {
        this.file = file;
        this.line = line;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }
}

