/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.remote;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.integration.api.ThingsboardPlatformIntegration;
import org.thingsboard.integration.api.controller.AbstractIntegrationControllerApi;
import org.thingsboard.integration.service.RemoteIntegrationManagerService;
import org.thingsboard.server.queue.util.TbIntegrationComponent;

@TbIntegrationComponent
@Component
public class RemoteIntegrationControllerApi
extends AbstractIntegrationControllerApi {
    private static final Logger log = LoggerFactory.getLogger(RemoteIntegrationControllerApi.class);
    private ListeningExecutorService service;
    @Value(value="${executors.thread_pool_size}")
    private int executorThreadPoolSize;
    @Autowired
    private RemoteIntegrationManagerService managerService;

    @PostConstruct
    public void init() {
        this.service = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)this.executorThreadPoolSize, ((Object)((Object)this)).getClass()));
    }

    @PreDestroy
    public void destroy() {
        if (this.service != null) {
            this.service.shutdown();
        }
    }

    protected ListenableFuture<ThingsboardPlatformIntegration> getIntegrationByRoutingKey(String routingKey) {
        return Futures.immediateFuture(this.managerService.getIntegration());
    }

    protected Executor getCallbackExecutor() {
        return this.service;
    }
}

