/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.EventUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.integration.api.IntegrationContext;
import org.thingsboard.integration.api.IntegrationStatistics;
import org.thingsboard.integration.api.TbIntegrationInitParams;
import org.thingsboard.integration.api.ThingsboardPlatformIntegration;
import org.thingsboard.integration.api.converter.ScriptDownlinkDataConverter;
import org.thingsboard.integration.api.converter.ScriptUplinkDataConverter;
import org.thingsboard.integration.api.converter.TBDownlinkDataConverter;
import org.thingsboard.integration.api.converter.TBUplinkDataConverter;
import org.thingsboard.integration.api.data.DefaultIntegrationDownlinkMsg;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.integration.api.util.IntegrationUtil;
import org.thingsboard.integration.api.util.LogSettingsComponent;
import org.thingsboard.integration.remote.RemoteIntegrationContext;
import org.thingsboard.integration.rpc.IntegrationRpcClient;
import org.thingsboard.integration.storage.EventStorage;
import org.thingsboard.script.api.js.JsInvokeService;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.coapserver.CoapServerService;
import org.thingsboard.server.common.data.FSTUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.converter.ConverterType;
import org.thingsboard.server.common.data.event.LifecycleEvent;
import org.thingsboard.server.common.data.event.StatisticsEvent;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;
import org.thingsboard.server.gen.integration.ConverterConfigurationProto;
import org.thingsboard.server.gen.integration.DeviceDownlinkDataProto;
import org.thingsboard.server.gen.integration.IntegrationConfigurationProto;
import org.thingsboard.server.gen.integration.IntegrationStatisticsProto;
import org.thingsboard.server.gen.integration.TbEventProto;
import org.thingsboard.server.gen.integration.TbEventSource;
import org.thingsboard.server.gen.integration.UplinkMsg;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbIntegrationComponent;

@Service(value="RemoteIntegrationManagerService")
@TbIntegrationComponent
public class RemoteIntegrationManagerService {
    private static final Logger log = LoggerFactory.getLogger(RemoteIntegrationManagerService.class);
    public static final ObjectMapper mapper = new ObjectMapper();
    @Value(value="${rpc.client_id}")
    private String clientId;
    @Value(value="${server.port}")
    private int port;
    @Value(value="${integration.routingKey}")
    private String routingKey;
    @Value(value="${integration.secret}")
    private String routingSecret;
    @Value(value="${integration.allow_local_network_hosts:true}")
    private boolean allowLocalNetworkHosts;
    @Value(value="${executors.reconnect_timeout}")
    private long reconnectTimeoutMs;
    @Value(value="${integration.statistics.enabled}")
    private boolean statisticsEnabled;
    @Value(value="${integration.statistics.persist_frequency}")
    private long statisticsPersistFrequency;
    @Autowired
    private IntegrationRpcClient rpcClient;
    @Autowired
    private EventStorage eventStorage;
    @Autowired
    private JsInvokeService jsInvokeService;
    @Autowired(required=false)
    private TbelInvokeService tbelInvokeService;
    @Autowired
    private LogSettingsComponent logSettingsComponent;
    @Autowired(required=false)
    private CoapServerService coapServerService;
    private ThingsboardPlatformIntegration<?> integration;
    private ComponentLifecycleEvent integrationEvent;
    private TBUplinkDataConverter uplinkDataConverter;
    private TBDownlinkDataConverter downlinkDataConverter;
    private ConverterId uplinkConverterId;
    private ConverterId downlinkConverterId;
    private ExecutorService executor;
    private ScheduledExecutorService reconnectScheduler;
    private ScheduledExecutorService statisticsExecutorService;
    private ScheduledExecutorService schedulerService;
    private ExecutorService generalExecutorService;
    private ScheduledFuture<?> scheduledFuture;
    private ExecutorService callBackExecutorService;
    private volatile boolean initialized;
    private volatile boolean updatingIntegration;
    private String serviceId;

    @PostConstruct
    public void init() {
        if (StringUtils.isBlank((String)this.routingKey)) {
            log.error("The routing key is blank. Please define 'INTEGRATION_ROUTING_KEY' environment variable!");
            System.exit(-1);
        }
        if (StringUtils.isBlank((String)this.routingSecret)) {
            log.error("The routing secret is blank. Please define 'INTEGRATION_SECRET' environment variable!");
            System.exit(-1);
        }
        if ("PUT_YOUR_ROUTING_KEY_HERE".equals(this.routingKey)) {
            log.error("The routing key is default. Please define 'INTEGRATION_ROUTING_KEY' environment variable!");
            System.exit(-1);
        }
        if ("PUT_YOUR_SECRET_HERE".equals(this.routingSecret)) {
            log.error("The routing secret is default. Please define 'INTEGRATION_SECRET' environment variable!");
            System.exit(-1);
        }
        this.serviceId = "[" + this.clientId + ":" + this.port + "]";
        this.rpcClient.connect(this.routingKey, this.routingSecret, this.serviceId, this::onConfigurationUpdate, this::onConverterConfigurationUpdate, this::onDownlink, this::scheduleReconnect);
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"remote-integration-manager-service"));
        this.reconnectScheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"remote-integration-manager-service-reconnect"));
        this.schedulerService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"remote-integration-manager-service-scheduler"));
        this.generalExecutorService = ThingsBoardExecutors.newWorkStealingPool((int)Math.max(2, Runtime.getRuntime().availableProcessors()), (String)"remote-integration-general");
        this.callBackExecutorService = ThingsBoardExecutors.newWorkStealingPool((int)Math.max(2, Runtime.getRuntime().availableProcessors()), (String)"remote-integration-callback");
        this.processHandleMessages();
        if (this.statisticsEnabled) {
            this.statisticsExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"remote-integration-manager-service-stats"));
            this.statisticsExecutorService.scheduleAtFixedRate(this::persistStatistics, this.statisticsPersistFrequency, this.statisticsPersistFrequency, TimeUnit.MILLISECONDS);
        }
    }

    @PreDestroy
    public void destroy() throws InterruptedException {
        log.info("[{}] Starting destroying process", (Object)this.serviceId);
        this.initialized = false;
        if (this.uplinkDataConverter != null) {
            this.uplinkDataConverter.destroy();
        }
        if (this.downlinkDataConverter != null) {
            this.downlinkDataConverter.destroy();
        }
        if (this.integration != null) {
            this.integration.destroy();
        }
        try {
            this.rpcClient.disconnect();
        }
        catch (Exception e) {
            log.error("Exception during disconnect", (Throwable)e);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.reconnectScheduler != null) {
            this.reconnectScheduler.shutdownNow();
        }
        if (this.statisticsEnabled && this.statisticsExecutorService != null) {
            this.statisticsExecutorService.shutdownNow();
        }
        if (this.schedulerService != null) {
            this.schedulerService.shutdownNow();
        }
        if (this.generalExecutorService != null) {
            this.generalExecutorService.shutdownNow();
        }
        if (this.callBackExecutorService != null) {
            this.callBackExecutorService.shutdownNow();
        }
        log.info("[{}] Destroy was successful", (Object)this.serviceId);
    }

    private void onConfigurationUpdate(IntegrationConfigurationProto integrationConfigurationProto) {
        if (this.integration != null) {
            this.updatingIntegration = true;
            this.integration.destroy();
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        try {
            Integration configuration = this.createIntegrationConfiguration(integrationConfigurationProto);
            if (configuration.isEnabled().booleanValue()) {
                this.integration = IntegrationUtil.createPlatformIntegration((IntegrationType)IntegrationType.valueOf((String)integrationConfigurationProto.getType()), (JsonNode)configuration.getConfiguration(), (boolean)true, (Object)this.coapServerService);
                this.integration.validateConfiguration(configuration, this.allowLocalNetworkHosts);
                if (this.uplinkDataConverter == null || !this.uplinkDataConverter.getName().equals(integrationConfigurationProto.getUplinkConverter().getName())) {
                    this.uplinkDataConverter = this.createUplinkConverter(integrationConfigurationProto.getUplinkConverter());
                }
                if (this.downlinkDataConverter == null || !this.downlinkDataConverter.getName().equals(integrationConfigurationProto.getDownlinkConverter().getName())) {
                    this.downlinkDataConverter = this.createDownlinkConverter(integrationConfigurationProto.getDownlinkConverter());
                }
                TbIntegrationInitParams params = new TbIntegrationInitParams((IntegrationContext)new RemoteIntegrationContext(this.eventStorage, this.schedulerService, this.generalExecutorService, this.callBackExecutorService, configuration, this.clientId, this.port), configuration, this.uplinkDataConverter, this.downlinkDataConverter);
                this.integration.init(params);
                if (this.updatingIntegration) {
                    this.integrationEvent = ComponentLifecycleEvent.UPDATED;
                    this.persistLifecycleEvent(ComponentLifecycleEvent.UPDATED, null);
                } else {
                    this.integrationEvent = ComponentLifecycleEvent.STARTED;
                    this.persistLifecycleEvent(ComponentLifecycleEvent.STARTED, null);
                }
            } else if (!ComponentLifecycleEvent.STOPPED.equals((Object)this.integrationEvent)) {
                if (this.statisticsEnabled) {
                    this.persistStatistics();
                }
                this.integrationEvent = ComponentLifecycleEvent.STOPPED;
                this.persistLifecycleEvent(ComponentLifecycleEvent.STOPPED, null);
                this.integration = null;
            }
            this.initialized = true;
        }
        catch (Exception e) {
            log.error("Failed to initialize platform integration!", (Throwable)e);
            this.integrationEvent = ComponentLifecycleEvent.FAILED;
            this.persistLifecycleEvent(ComponentLifecycleEvent.FAILED, e);
        }
    }

    private void onConverterConfigurationUpdate(ConverterConfigurationProto converterProto) {
        TBUplinkDataConverter tbDataConverter;
        ConverterType converterType;
        ConverterId converterId = new ConverterId(new UUID(converterProto.getConverterIdMSB(), converterProto.getConverterIdLSB()));
        if (converterId.equals((Object)this.uplinkConverterId)) {
            converterType = ConverterType.UPLINK;
            tbDataConverter = this.uplinkDataConverter;
        } else {
            converterType = ConverterType.DOWNLINK;
            tbDataConverter = this.downlinkDataConverter;
        }
        try {
            tbDataConverter.update(this.constructConverter(converterProto, converterType));
        }
        catch (IOException e) {
            log.error("[{}] Failed to update converter configuration", (Object)converterId, (Object)e);
        }
    }

    private void onDownlink(DeviceDownlinkDataProto deviceDownlinkDataProto) {
        DefaultIntegrationDownlinkMsg downlinkMsg = new DefaultIntegrationDownlinkMsg(this.integration.getConfiguration().getTenantId(), this.integration.getConfiguration().getId(), TbMsg.fromBytes(null, (byte[])deviceDownlinkDataProto.getTbMsg().toByteArray(), (TbMsgCallback)TbMsgCallback.EMPTY), deviceDownlinkDataProto.getDeviceName());
        this.integration.onDownlinkMsg((IntegrationDownlinkMsg)downlinkMsg);
    }

    private TBUplinkDataConverter createUplinkConverter(ConverterConfigurationProto uplinkConverter) throws IOException {
        ScriptUplinkDataConverter uplinkDataConverter = new ScriptUplinkDataConverter(this.jsInvokeService, this.tbelInvokeService, this.logSettingsComponent);
        Converter converter = this.constructConverter(uplinkConverter, ConverterType.UPLINK);
        this.uplinkConverterId = converter.getId();
        uplinkDataConverter.init(converter);
        return uplinkDataConverter;
    }

    private TBDownlinkDataConverter createDownlinkConverter(ConverterConfigurationProto downLinkConverter) throws IOException {
        if (!StringUtils.isEmpty((String)downLinkConverter.getConfiguration())) {
            ScriptDownlinkDataConverter downlinkDataConverter = new ScriptDownlinkDataConverter(this.jsInvokeService, this.tbelInvokeService, this.logSettingsComponent);
            Converter converter = this.constructConverter(downLinkConverter, ConverterType.DOWNLINK);
            this.downlinkConverterId = converter.getId();
            downlinkDataConverter.init(converter);
            return downlinkDataConverter;
        }
        return null;
    }

    private Converter constructConverter(ConverterConfigurationProto converterProto, ConverterType converterType) throws IOException {
        Converter converter = new Converter();
        converter.setId((UUIDBased)new ConverterId(new UUID(converterProto.getConverterIdMSB(), converterProto.getConverterIdLSB())));
        converter.setTenantId(new TenantId(new UUID(converterProto.getTenantIdMSB(), converterProto.getTenantIdLSB())));
        converter.setName(converterProto.getName());
        converter.setType(converterType);
        converter.setDebugMode(converterProto.getDebugMode());
        converter.setConfiguration(mapper.readTree(converterProto.getConfiguration()));
        converter.setAdditionalInfo(mapper.readTree(converterProto.getAdditionalInfo()));
        return converter;
    }

    private Integration createIntegrationConfiguration(IntegrationConfigurationProto integrationConfigurationProto) throws IOException {
        Integration integration = new Integration();
        IntegrationId integrationId = new IntegrationId(new UUID(integrationConfigurationProto.getIntegrationIdMSB(), integrationConfigurationProto.getIntegrationIdLSB()));
        TenantId tenantId = new TenantId(new UUID(integrationConfigurationProto.getTenantIdMSB(), integrationConfigurationProto.getTenantIdLSB()));
        ConverterId defaultConverterId = new ConverterId(new UUID(integrationConfigurationProto.getUplinkConverter().getConverterIdMSB(), integrationConfigurationProto.getUplinkConverter().getConverterIdLSB()));
        ConverterId downlinkConverterId = new ConverterId(new UUID(integrationConfigurationProto.getDownlinkConverter().getConverterIdMSB(), integrationConfigurationProto.getDownlinkConverter().getConverterIdLSB()));
        integration.setId((UUIDBased)integrationId);
        integration.setTenantId(tenantId);
        integration.setDefaultConverterId(defaultConverterId);
        integration.setDownlinkConverterId(downlinkConverterId);
        integration.setName(integrationConfigurationProto.getName());
        integration.setRoutingKey(integrationConfigurationProto.getRoutingKey());
        integration.setType(IntegrationType.valueOf((String)integrationConfigurationProto.getType()));
        integration.setDebugMode(integrationConfigurationProto.getDebugMode());
        integration.setRemote(Boolean.valueOf(true));
        integration.setSecret(this.routingSecret);
        integration.setConfiguration(mapper.readTree(integrationConfigurationProto.getConfiguration()));
        integration.setAdditionalInfo(mapper.readTree(integrationConfigurationProto.getAdditionalInfo()));
        Descriptors.FieldDescriptor enabledField = integrationConfigurationProto.getDescriptorForType().findFieldByName("enabled");
        if (enabledField == null) {
            integration.setEnabled(Boolean.valueOf(true));
        } else {
            integration.setEnabled(Boolean.valueOf(integrationConfigurationProto.getEnabled()));
        }
        log.info("Received Integration update: {}!", (Object)integration);
        return integration;
    }

    private void scheduleReconnect(Exception e) {
        this.initialized = false;
        if (this.scheduledFuture == null) {
            this.scheduledFuture = this.reconnectScheduler.scheduleAtFixedRate(() -> {
                log.info("Trying to reconnect due to the error: {}!", (Object)e.getMessage());
                try {
                    this.rpcClient.disconnect();
                }
                catch (Exception ex) {
                    log.error("Exception during disconnect: {}", (Object)ex.getMessage());
                }
                this.rpcClient.connect(this.routingKey, this.routingSecret, this.serviceId, this::onConfigurationUpdate, this::onConverterConfigurationUpdate, this::onDownlink, this::scheduleReconnect);
            }, 0L, this.reconnectTimeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    private void processHandleMessages() {
        this.executor.submit(() -> {
            boolean interrupted = false;
            while (!interrupted) {
                try {
                    if (this.initialized) {
                        this.rpcClient.handleMsgs();
                    } else {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                catch (Exception e) {
                    log.warn("Failed to process messages handling!", (Throwable)e);
                }
                if (interrupted) continue;
                interrupted = Thread.interrupted();
            }
        });
    }

    private void persistStatistics() {
        long ts = System.currentTimeMillis();
        IntegrationStatistics statistics = this.integration.popStatistics();
        try {
            StatisticsEvent statsEvent = StatisticsEvent.builder().tenantId(this.integration.getConfiguration().getTenantId()).entityId(this.integration.getConfiguration().getId().getId()).serviceId(this.getServiceId()).messagesProcessed(statistics.getMessagesProcessed()).errorsOccurred(statistics.getErrorsOccurred()).build();
            this.eventStorage.write(UplinkMsg.newBuilder().addEventsData(TbEventProto.newBuilder().setSource(TbEventSource.INTEGRATION).setEvent(ByteString.copyFrom((byte[])FSTUtils.encode((Object)statsEvent))).build()).build(), null);
            TransportProtos.PostTelemetryMsg.Builder telemetryBuilder = TransportProtos.PostTelemetryMsg.newBuilder();
            ArrayList<TransportProtos.KeyValueProto> telemetryResult = new ArrayList<TransportProtos.KeyValueProto>();
            telemetryResult.add(TransportProtos.KeyValueProto.newBuilder().setKey("messagesCount").setType(TransportProtos.KeyValueType.LONG_V).setLongV(statistics.getMessagesProcessed()).build());
            telemetryResult.add(TransportProtos.KeyValueProto.newBuilder().setKey("errorsCount").setType(TransportProtos.KeyValueType.LONG_V).setLongV(statistics.getErrorsOccurred()).build());
            telemetryResult.add(TransportProtos.KeyValueProto.newBuilder().setKey("state").setType(TransportProtos.KeyValueType.STRING_V).setStringV(this.integrationEvent != null ? this.integrationEvent.name() : "N/A").build());
            TransportProtos.TsKvListProto.Builder tsKvListBuilder = TransportProtos.TsKvListProto.newBuilder();
            tsKvListBuilder.setTs(ts);
            tsKvListBuilder.addAllKv(telemetryResult);
            telemetryBuilder.addTsKvList(tsKvListBuilder.build());
            this.eventStorage.write(UplinkMsg.newBuilder().addIntegrationStatistics(IntegrationStatisticsProto.newBuilder().setPostTelemetryMsg(telemetryBuilder.build()).build()).build(), null);
        }
        catch (Exception e) {
            log.warn("[{}] Failed to persist statistics: {}", new Object[]{this.integration.getConfiguration().getId(), statistics, e});
        }
    }

    private void persistLifecycleEvent(ComponentLifecycleEvent event, Exception e) {
        LifecycleEvent.LifecycleEventBuilder lcEvent = LifecycleEvent.builder().tenantId(this.integration.getConfiguration().getTenantId()).entityId(this.integration.getConfiguration().getId().getId()).serviceId(this.getServiceId()).lcEventType(event.name());
        if (e != null) {
            lcEvent.success(false).error(EventUtil.toString((Throwable)e));
        } else {
            lcEvent.success(true);
        }
        this.eventStorage.write(UplinkMsg.newBuilder().addEventsData(TbEventProto.newBuilder().setSource(TbEventSource.INTEGRATION).setEvent(ByteString.copyFrom((byte[])FSTUtils.encode((Object)lcEvent.build()))).build()).build(), null);
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getPort() {
        return this.port;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public String getRoutingSecret() {
        return this.routingSecret;
    }

    public boolean isAllowLocalNetworkHosts() {
        return this.allowLocalNetworkHosts;
    }

    public long getReconnectTimeoutMs() {
        return this.reconnectTimeoutMs;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public long getStatisticsPersistFrequency() {
        return this.statisticsPersistFrequency;
    }

    public IntegrationRpcClient getRpcClient() {
        return this.rpcClient;
    }

    public EventStorage getEventStorage() {
        return this.eventStorage;
    }

    public JsInvokeService getJsInvokeService() {
        return this.jsInvokeService;
    }

    public TbelInvokeService getTbelInvokeService() {
        return this.tbelInvokeService;
    }

    public LogSettingsComponent getLogSettingsComponent() {
        return this.logSettingsComponent;
    }

    public CoapServerService getCoapServerService() {
        return this.coapServerService;
    }

    public ThingsboardPlatformIntegration<?> getIntegration() {
        return this.integration;
    }

    public ComponentLifecycleEvent getIntegrationEvent() {
        return this.integrationEvent;
    }

    public TBUplinkDataConverter getUplinkDataConverter() {
        return this.uplinkDataConverter;
    }

    public TBDownlinkDataConverter getDownlinkDataConverter() {
        return this.downlinkDataConverter;
    }

    public ConverterId getUplinkConverterId() {
        return this.uplinkConverterId;
    }

    public ConverterId getDownlinkConverterId() {
        return this.downlinkConverterId;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getReconnectScheduler() {
        return this.reconnectScheduler;
    }

    public ScheduledExecutorService getStatisticsExecutorService() {
        return this.statisticsExecutorService;
    }

    public ScheduledExecutorService getSchedulerService() {
        return this.schedulerService;
    }

    public ExecutorService getGeneralExecutorService() {
        return this.generalExecutorService;
    }

    public ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    public ExecutorService getCallBackExecutorService() {
        return this.callBackExecutorService;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isUpdatingIntegration() {
        return this.updatingIntegration;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setRoutingSecret(String routingSecret) {
        this.routingSecret = routingSecret;
    }

    public void setAllowLocalNetworkHosts(boolean allowLocalNetworkHosts) {
        this.allowLocalNetworkHosts = allowLocalNetworkHosts;
    }

    public void setReconnectTimeoutMs(long reconnectTimeoutMs) {
        this.reconnectTimeoutMs = reconnectTimeoutMs;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public void setStatisticsPersistFrequency(long statisticsPersistFrequency) {
        this.statisticsPersistFrequency = statisticsPersistFrequency;
    }

    public void setRpcClient(IntegrationRpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    public void setEventStorage(EventStorage eventStorage) {
        this.eventStorage = eventStorage;
    }

    public void setJsInvokeService(JsInvokeService jsInvokeService) {
        this.jsInvokeService = jsInvokeService;
    }

    public void setTbelInvokeService(TbelInvokeService tbelInvokeService) {
        this.tbelInvokeService = tbelInvokeService;
    }

    public void setLogSettingsComponent(LogSettingsComponent logSettingsComponent) {
        this.logSettingsComponent = logSettingsComponent;
    }

    public void setCoapServerService(CoapServerService coapServerService) {
        this.coapServerService = coapServerService;
    }

    public void setIntegration(ThingsboardPlatformIntegration<?> integration) {
        this.integration = integration;
    }

    public void setIntegrationEvent(ComponentLifecycleEvent integrationEvent) {
        this.integrationEvent = integrationEvent;
    }

    public void setUplinkDataConverter(TBUplinkDataConverter uplinkDataConverter) {
        this.uplinkDataConverter = uplinkDataConverter;
    }

    public void setDownlinkDataConverter(TBDownlinkDataConverter downlinkDataConverter) {
        this.downlinkDataConverter = downlinkDataConverter;
    }

    public void setUplinkConverterId(ConverterId uplinkConverterId) {
        this.uplinkConverterId = uplinkConverterId;
    }

    public void setDownlinkConverterId(ConverterId downlinkConverterId) {
        this.downlinkConverterId = downlinkConverterId;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setReconnectScheduler(ScheduledExecutorService reconnectScheduler) {
        this.reconnectScheduler = reconnectScheduler;
    }

    public void setStatisticsExecutorService(ScheduledExecutorService statisticsExecutorService) {
        this.statisticsExecutorService = statisticsExecutorService;
    }

    public void setSchedulerService(ScheduledExecutorService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setGeneralExecutorService(ExecutorService generalExecutorService) {
        this.generalExecutorService = generalExecutorService;
    }

    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public void setCallBackExecutorService(ExecutorService callBackExecutorService) {
        this.callBackExecutorService = callBackExecutorService;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setUpdatingIntegration(boolean updatingIntegration) {
        this.updatingIntegration = updatingIntegration;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteIntegrationManagerService)) {
            return false;
        }
        RemoteIntegrationManagerService other = (RemoteIntegrationManagerService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isAllowLocalNetworkHosts() != other.isAllowLocalNetworkHosts()) {
            return false;
        }
        if (this.getReconnectTimeoutMs() != other.getReconnectTimeoutMs()) {
            return false;
        }
        if (this.isStatisticsEnabled() != other.isStatisticsEnabled()) {
            return false;
        }
        if (this.getStatisticsPersistFrequency() != other.getStatisticsPersistFrequency()) {
            return false;
        }
        if (this.isInitialized() != other.isInitialized()) {
            return false;
        }
        if (this.isUpdatingIntegration() != other.isUpdatingIntegration()) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        String this$routingSecret = this.getRoutingSecret();
        String other$routingSecret = other.getRoutingSecret();
        if (this$routingSecret == null ? other$routingSecret != null : !this$routingSecret.equals(other$routingSecret)) {
            return false;
        }
        IntegrationRpcClient this$rpcClient = this.getRpcClient();
        IntegrationRpcClient other$rpcClient = other.getRpcClient();
        if (this$rpcClient == null ? other$rpcClient != null : !this$rpcClient.equals(other$rpcClient)) {
            return false;
        }
        EventStorage this$eventStorage = this.getEventStorage();
        EventStorage other$eventStorage = other.getEventStorage();
        if (this$eventStorage == null ? other$eventStorage != null : !this$eventStorage.equals(other$eventStorage)) {
            return false;
        }
        JsInvokeService this$jsInvokeService = this.getJsInvokeService();
        JsInvokeService other$jsInvokeService = other.getJsInvokeService();
        if (this$jsInvokeService == null ? other$jsInvokeService != null : !this$jsInvokeService.equals(other$jsInvokeService)) {
            return false;
        }
        TbelInvokeService this$tbelInvokeService = this.getTbelInvokeService();
        TbelInvokeService other$tbelInvokeService = other.getTbelInvokeService();
        if (this$tbelInvokeService == null ? other$tbelInvokeService != null : !this$tbelInvokeService.equals(other$tbelInvokeService)) {
            return false;
        }
        LogSettingsComponent this$logSettingsComponent = this.getLogSettingsComponent();
        LogSettingsComponent other$logSettingsComponent = other.getLogSettingsComponent();
        if (this$logSettingsComponent == null ? other$logSettingsComponent != null : !this$logSettingsComponent.equals(other$logSettingsComponent)) {
            return false;
        }
        CoapServerService this$coapServerService = this.getCoapServerService();
        CoapServerService other$coapServerService = other.getCoapServerService();
        if (this$coapServerService == null ? other$coapServerService != null : !this$coapServerService.equals(other$coapServerService)) {
            return false;
        }
        ThingsboardPlatformIntegration<?> this$integration = this.getIntegration();
        ThingsboardPlatformIntegration<?> other$integration = other.getIntegration();
        if (this$integration == null ? other$integration != null : !this$integration.equals(other$integration)) {
            return false;
        }
        ComponentLifecycleEvent this$integrationEvent = this.getIntegrationEvent();
        ComponentLifecycleEvent other$integrationEvent = other.getIntegrationEvent();
        if (this$integrationEvent == null ? other$integrationEvent != null : !this$integrationEvent.equals(other$integrationEvent)) {
            return false;
        }
        TBUplinkDataConverter this$uplinkDataConverter = this.getUplinkDataConverter();
        TBUplinkDataConverter other$uplinkDataConverter = other.getUplinkDataConverter();
        if (this$uplinkDataConverter == null ? other$uplinkDataConverter != null : !this$uplinkDataConverter.equals(other$uplinkDataConverter)) {
            return false;
        }
        TBDownlinkDataConverter this$downlinkDataConverter = this.getDownlinkDataConverter();
        TBDownlinkDataConverter other$downlinkDataConverter = other.getDownlinkDataConverter();
        if (this$downlinkDataConverter == null ? other$downlinkDataConverter != null : !this$downlinkDataConverter.equals(other$downlinkDataConverter)) {
            return false;
        }
        ConverterId this$uplinkConverterId = this.getUplinkConverterId();
        ConverterId other$uplinkConverterId = other.getUplinkConverterId();
        if (this$uplinkConverterId == null ? other$uplinkConverterId != null : !this$uplinkConverterId.equals(other$uplinkConverterId)) {
            return false;
        }
        ConverterId this$downlinkConverterId = this.getDownlinkConverterId();
        ConverterId other$downlinkConverterId = other.getDownlinkConverterId();
        if (this$downlinkConverterId == null ? other$downlinkConverterId != null : !this$downlinkConverterId.equals(other$downlinkConverterId)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        ScheduledExecutorService this$reconnectScheduler = this.getReconnectScheduler();
        ScheduledExecutorService other$reconnectScheduler = other.getReconnectScheduler();
        if (this$reconnectScheduler == null ? other$reconnectScheduler != null : !this$reconnectScheduler.equals(other$reconnectScheduler)) {
            return false;
        }
        ScheduledExecutorService this$statisticsExecutorService = this.getStatisticsExecutorService();
        ScheduledExecutorService other$statisticsExecutorService = other.getStatisticsExecutorService();
        if (this$statisticsExecutorService == null ? other$statisticsExecutorService != null : !this$statisticsExecutorService.equals(other$statisticsExecutorService)) {
            return false;
        }
        ScheduledExecutorService this$schedulerService = this.getSchedulerService();
        ScheduledExecutorService other$schedulerService = other.getSchedulerService();
        if (this$schedulerService == null ? other$schedulerService != null : !this$schedulerService.equals(other$schedulerService)) {
            return false;
        }
        ExecutorService this$generalExecutorService = this.getGeneralExecutorService();
        ExecutorService other$generalExecutorService = other.getGeneralExecutorService();
        if (this$generalExecutorService == null ? other$generalExecutorService != null : !this$generalExecutorService.equals(other$generalExecutorService)) {
            return false;
        }
        ScheduledFuture<?> this$scheduledFuture = this.getScheduledFuture();
        ScheduledFuture<?> other$scheduledFuture = other.getScheduledFuture();
        if (this$scheduledFuture == null ? other$scheduledFuture != null : !this$scheduledFuture.equals(other$scheduledFuture)) {
            return false;
        }
        ExecutorService this$callBackExecutorService = this.getCallBackExecutorService();
        ExecutorService other$callBackExecutorService = other.getCallBackExecutorService();
        if (this$callBackExecutorService == null ? other$callBackExecutorService != null : !this$callBackExecutorService.equals(other$callBackExecutorService)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        return !(this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteIntegrationManagerService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isAllowLocalNetworkHosts() ? 79 : 97);
        long $reconnectTimeoutMs = this.getReconnectTimeoutMs();
        result = result * 59 + (int)($reconnectTimeoutMs >>> 32 ^ $reconnectTimeoutMs);
        result = result * 59 + (this.isStatisticsEnabled() ? 79 : 97);
        long $statisticsPersistFrequency = this.getStatisticsPersistFrequency();
        result = result * 59 + (int)($statisticsPersistFrequency >>> 32 ^ $statisticsPersistFrequency);
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        result = result * 59 + (this.isUpdatingIntegration() ? 79 : 97);
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        String $routingSecret = this.getRoutingSecret();
        result = result * 59 + ($routingSecret == null ? 43 : $routingSecret.hashCode());
        IntegrationRpcClient $rpcClient = this.getRpcClient();
        result = result * 59 + ($rpcClient == null ? 43 : $rpcClient.hashCode());
        EventStorage $eventStorage = this.getEventStorage();
        result = result * 59 + ($eventStorage == null ? 43 : $eventStorage.hashCode());
        JsInvokeService $jsInvokeService = this.getJsInvokeService();
        result = result * 59 + ($jsInvokeService == null ? 43 : $jsInvokeService.hashCode());
        TbelInvokeService $tbelInvokeService = this.getTbelInvokeService();
        result = result * 59 + ($tbelInvokeService == null ? 43 : $tbelInvokeService.hashCode());
        LogSettingsComponent $logSettingsComponent = this.getLogSettingsComponent();
        result = result * 59 + ($logSettingsComponent == null ? 43 : $logSettingsComponent.hashCode());
        CoapServerService $coapServerService = this.getCoapServerService();
        result = result * 59 + ($coapServerService == null ? 43 : $coapServerService.hashCode());
        ThingsboardPlatformIntegration<?> $integration = this.getIntegration();
        result = result * 59 + ($integration == null ? 43 : $integration.hashCode());
        ComponentLifecycleEvent $integrationEvent = this.getIntegrationEvent();
        result = result * 59 + ($integrationEvent == null ? 43 : $integrationEvent.hashCode());
        TBUplinkDataConverter $uplinkDataConverter = this.getUplinkDataConverter();
        result = result * 59 + ($uplinkDataConverter == null ? 43 : $uplinkDataConverter.hashCode());
        TBDownlinkDataConverter $downlinkDataConverter = this.getDownlinkDataConverter();
        result = result * 59 + ($downlinkDataConverter == null ? 43 : $downlinkDataConverter.hashCode());
        ConverterId $uplinkConverterId = this.getUplinkConverterId();
        result = result * 59 + ($uplinkConverterId == null ? 43 : $uplinkConverterId.hashCode());
        ConverterId $downlinkConverterId = this.getDownlinkConverterId();
        result = result * 59 + ($downlinkConverterId == null ? 43 : $downlinkConverterId.hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        ScheduledExecutorService $reconnectScheduler = this.getReconnectScheduler();
        result = result * 59 + ($reconnectScheduler == null ? 43 : $reconnectScheduler.hashCode());
        ScheduledExecutorService $statisticsExecutorService = this.getStatisticsExecutorService();
        result = result * 59 + ($statisticsExecutorService == null ? 43 : $statisticsExecutorService.hashCode());
        ScheduledExecutorService $schedulerService = this.getSchedulerService();
        result = result * 59 + ($schedulerService == null ? 43 : $schedulerService.hashCode());
        ExecutorService $generalExecutorService = this.getGeneralExecutorService();
        result = result * 59 + ($generalExecutorService == null ? 43 : $generalExecutorService.hashCode());
        ScheduledFuture<?> $scheduledFuture = this.getScheduledFuture();
        result = result * 59 + ($scheduledFuture == null ? 43 : $scheduledFuture.hashCode());
        ExecutorService $callBackExecutorService = this.getCallBackExecutorService();
        result = result * 59 + ($callBackExecutorService == null ? 43 : $callBackExecutorService.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        return result;
    }

    public String toString() {
        return "RemoteIntegrationManagerService(clientId=" + this.getClientId() + ", port=" + this.getPort() + ", routingKey=" + this.getRoutingKey() + ", routingSecret=" + this.getRoutingSecret() + ", allowLocalNetworkHosts=" + this.isAllowLocalNetworkHosts() + ", reconnectTimeoutMs=" + this.getReconnectTimeoutMs() + ", statisticsEnabled=" + this.isStatisticsEnabled() + ", statisticsPersistFrequency=" + this.getStatisticsPersistFrequency() + ", rpcClient=" + this.getRpcClient() + ", eventStorage=" + this.getEventStorage() + ", jsInvokeService=" + this.getJsInvokeService() + ", tbelInvokeService=" + this.getTbelInvokeService() + ", logSettingsComponent=" + this.getLogSettingsComponent() + ", coapServerService=" + this.getCoapServerService() + ", integration=" + this.getIntegration() + ", integrationEvent=" + this.getIntegrationEvent() + ", uplinkDataConverter=" + this.getUplinkDataConverter() + ", downlinkDataConverter=" + this.getDownlinkDataConverter() + ", uplinkConverterId=" + this.getUplinkConverterId() + ", downlinkConverterId=" + this.getDownlinkConverterId() + ", executor=" + this.getExecutor() + ", reconnectScheduler=" + this.getReconnectScheduler() + ", statisticsExecutorService=" + this.getStatisticsExecutorService() + ", schedulerService=" + this.getSchedulerService() + ", generalExecutorService=" + this.getGeneralExecutorService() + ", scheduledFuture=" + this.getScheduledFuture() + ", callBackExecutorService=" + this.getCallBackExecutorService() + ", initialized=" + this.isInitialized() + ", updatingIntegration=" + this.isUpdatingIntegration() + ", serviceId=" + this.getServiceId() + ")";
    }
}

