/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.remote;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.IntegrationContext;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.data.DownLinkMsg;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.integration.remote.RemoteConverterContext;
import org.thingsboard.integration.storage.EventStorage;
import org.thingsboard.server.common.data.FSTUtils;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.IntegrationDebugEvent;
import org.thingsboard.server.common.data.event.RawDataEvent;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.gen.integration.AssetUplinkDataProto;
import org.thingsboard.server.gen.integration.DeviceUplinkDataProto;
import org.thingsboard.server.gen.integration.EntityViewDataProto;
import org.thingsboard.server.gen.integration.TbEventProto;
import org.thingsboard.server.gen.integration.TbEventSource;
import org.thingsboard.server.gen.integration.UplinkMsg;

public class RemoteIntegrationContext
implements IntegrationContext {
    private static final Logger log = LoggerFactory.getLogger(RemoteIntegrationContext.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String REMOTE_INTEGRATION_CACHE = "remoteIntegration";
    protected final EventStorage eventStorage;
    protected final Integration configuration;
    protected final String clientId;
    protected final int port;
    protected final ConverterContext uplinkConverterContext;
    protected final ConverterContext downlinkConverterContext;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final ExecutorService generalExecutorService;
    protected final ExecutorService callBackExecutorService;

    public RemoteIntegrationContext(EventStorage eventStorage, ScheduledExecutorService scheduledExecutorService, ExecutorService generalExecutorService, ExecutorService callBackExecutorService, Integration configuration, String clientId, int port) {
        this.eventStorage = eventStorage;
        this.configuration = configuration;
        this.clientId = clientId;
        this.port = port;
        this.uplinkConverterContext = new RemoteConverterContext(eventStorage, true, mapper, clientId, port);
        this.downlinkConverterContext = new RemoteConverterContext(eventStorage, false, mapper, clientId, port);
        this.scheduledExecutorService = scheduledExecutorService;
        this.generalExecutorService = generalExecutorService;
        this.callBackExecutorService = callBackExecutorService;
    }

    public String getServiceId() {
        return "[" + this.clientId + ":" + this.port + "]";
    }

    public void processUplinkData(DeviceUplinkDataProto msg, IntegrationCallback<Void> callback) {
        this.eventStorage.write(UplinkMsg.newBuilder().addDeviceData(msg).build(), callback);
    }

    public void processUplinkData(AssetUplinkDataProto msg, IntegrationCallback<Void> callback) {
        this.eventStorage.write(UplinkMsg.newBuilder().addAssetData(msg).build(), callback);
    }

    public void createEntityView(EntityViewDataProto msg, IntegrationCallback<Void> callback) {
        this.eventStorage.write(UplinkMsg.newBuilder().addEntityViewData(msg).build(), callback);
    }

    public void processCustomMsg(TbMsg msg, IntegrationCallback<Void> callback) {
        this.eventStorage.write(UplinkMsg.newBuilder().addTbMsg(TbMsg.toByteString((TbMsg)msg)).build(), callback);
    }

    public void saveEvent(IntegrationDebugEvent event, IntegrationCallback<Void> callback) {
        this.doSaveEvent(TbEventSource.INTEGRATION, (Event)event, null, callback);
    }

    public void saveRawDataEvent(String deviceName, String type, String uid, JsonNode body, IntegrationCallback<Void> callback) {
        this.doSaveEvent(TbEventSource.DEVICE, (Event)RawDataEvent.builder().tenantId(this.configuration.getTenantId()).serviceId(this.getServiceId()).uuid(uid).messageType(type).message(body.toString()).build(), deviceName, callback);
    }

    public EventLoopGroup getEventLoopGroup() {
        return null;
    }

    public DownLinkMsg getDownlinkMsg(String deviceName) {
        return null;
    }

    public DownLinkMsg putDownlinkMsg(IntegrationDownlinkMsg msg) {
        return null;
    }

    public void removeDownlinkMsg(String deviceName) {
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public ExecutorService getExecutorService() {
        return this.generalExecutorService;
    }

    public ExecutorService getCallBackExecutorService() {
        return this.callBackExecutorService;
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isExceptionStackTraceEnabled() {
        return true;
    }

    private void doSaveEvent(TbEventSource tbEventSource, Event event, String deviceName, IntegrationCallback<Void> callback) {
        TbEventProto.Builder builder = TbEventProto.newBuilder().setSource(tbEventSource).setEvent(ByteString.copyFrom((byte[])FSTUtils.encode((Object)event)));
        if (deviceName != null) {
            builder.setDeviceName(deviceName);
        }
        this.eventStorage.write(UplinkMsg.newBuilder().addEventsData(builder.build()).build(), callback);
    }

    public EventStorage getEventStorage() {
        return this.eventStorage;
    }

    public Integration getConfiguration() {
        return this.configuration;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getPort() {
        return this.port;
    }

    public ConverterContext getUplinkConverterContext() {
        return this.uplinkConverterContext;
    }

    public ConverterContext getDownlinkConverterContext() {
        return this.downlinkConverterContext;
    }

    public ExecutorService getGeneralExecutorService() {
        return this.generalExecutorService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteIntegrationContext)) {
            return false;
        }
        RemoteIntegrationContext other = (RemoteIntegrationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        EventStorage this$eventStorage = this.getEventStorage();
        EventStorage other$eventStorage = other.getEventStorage();
        if (this$eventStorage == null ? other$eventStorage != null : !this$eventStorage.equals(other$eventStorage)) {
            return false;
        }
        Integration this$configuration = this.getConfiguration();
        Integration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        ConverterContext this$uplinkConverterContext = this.getUplinkConverterContext();
        ConverterContext other$uplinkConverterContext = other.getUplinkConverterContext();
        if (this$uplinkConverterContext == null ? other$uplinkConverterContext != null : !this$uplinkConverterContext.equals(other$uplinkConverterContext)) {
            return false;
        }
        ConverterContext this$downlinkConverterContext = this.getDownlinkConverterContext();
        ConverterContext other$downlinkConverterContext = other.getDownlinkConverterContext();
        if (this$downlinkConverterContext == null ? other$downlinkConverterContext != null : !this$downlinkConverterContext.equals(other$downlinkConverterContext)) {
            return false;
        }
        ScheduledExecutorService this$scheduledExecutorService = this.getScheduledExecutorService();
        ScheduledExecutorService other$scheduledExecutorService = other.getScheduledExecutorService();
        if (this$scheduledExecutorService == null ? other$scheduledExecutorService != null : !this$scheduledExecutorService.equals(other$scheduledExecutorService)) {
            return false;
        }
        ExecutorService this$generalExecutorService = this.getGeneralExecutorService();
        ExecutorService other$generalExecutorService = other.getGeneralExecutorService();
        if (this$generalExecutorService == null ? other$generalExecutorService != null : !this$generalExecutorService.equals(other$generalExecutorService)) {
            return false;
        }
        ExecutorService this$callBackExecutorService = this.getCallBackExecutorService();
        ExecutorService other$callBackExecutorService = other.getCallBackExecutorService();
        return !(this$callBackExecutorService == null ? other$callBackExecutorService != null : !this$callBackExecutorService.equals(other$callBackExecutorService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteIntegrationContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        EventStorage $eventStorage = this.getEventStorage();
        result = result * 59 + ($eventStorage == null ? 43 : $eventStorage.hashCode());
        Integration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        ConverterContext $uplinkConverterContext = this.getUplinkConverterContext();
        result = result * 59 + ($uplinkConverterContext == null ? 43 : $uplinkConverterContext.hashCode());
        ConverterContext $downlinkConverterContext = this.getDownlinkConverterContext();
        result = result * 59 + ($downlinkConverterContext == null ? 43 : $downlinkConverterContext.hashCode());
        ScheduledExecutorService $scheduledExecutorService = this.getScheduledExecutorService();
        result = result * 59 + ($scheduledExecutorService == null ? 43 : $scheduledExecutorService.hashCode());
        ExecutorService $generalExecutorService = this.getGeneralExecutorService();
        result = result * 59 + ($generalExecutorService == null ? 43 : $generalExecutorService.hashCode());
        ExecutorService $callBackExecutorService = this.getCallBackExecutorService();
        result = result * 59 + ($callBackExecutorService == null ? 43 : $callBackExecutorService.hashCode());
        return result;
    }

    public String toString() {
        return "RemoteIntegrationContext(eventStorage=" + this.getEventStorage() + ", configuration=" + this.getConfiguration() + ", clientId=" + this.getClientId() + ", port=" + this.getPort() + ", uplinkConverterContext=" + this.getUplinkConverterContext() + ", downlinkConverterContext=" + this.getDownlinkConverterContext() + ", scheduledExecutorService=" + this.getScheduledExecutorService() + ", generalExecutorService=" + this.getGeneralExecutorService() + ", callBackExecutorService=" + this.getCallBackExecutorService() + ")";
    }
}

