/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.storage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.storage.EventStorageFiles;
import org.thingsboard.integration.storage.FileEventStorageSettings;
import org.thingsboard.server.gen.integration.UplinkMsg;

class EventStorageWriter {
    private static final Logger log = LoggerFactory.getLogger(EventStorageWriter.class);
    private EventStorageFiles files;
    private FileEventStorageSettings settings;
    private File currentFile;
    private long currentFileRecordsCount;
    private BufferedWriter bufferedWriter;
    private boolean newRecordAfterFlush;

    EventStorageWriter(EventStorageFiles files, FileEventStorageSettings settings) {
        this.files = files;
        this.settings = settings;
        this.currentFile = files.getDataFiles().get(files.getDataFiles().size() - 1);
        this.currentFileRecordsCount = this.getNumberOfRecordsInFile(this.currentFile);
    }

    void write(UplinkMsg msg, IntegrationCallback<Void> callback) {
        this.newRecordAfterFlush = true;
        if (this.isFileFull(this.currentFileRecordsCount)) {
            if (log.isDebugEnabled()) {
                log.debug("File [{}] is full with [{}] records", (Object)this.currentFile.getName(), (Object)this.currentFileRecordsCount);
            }
            try {
                log.debug("Created new data file: {}", (Object)this.currentFile.getName());
                this.currentFile = this.createDataFile(Long.toString(System.currentTimeMillis()));
            }
            catch (IOException e) {
                log.error("Failed to create a new file!", (Throwable)e);
                if (callback != null) {
                    callback.onError((Throwable)e);
                }
                return;
            }
            while (this.files.getDataFiles().size() >= this.settings.getMaxFileCount()) {
                File firstFile = this.files.getDataFiles().get(0);
                if (firstFile.delete()) {
                    this.files.getDataFiles().remove(0);
                }
                log.info("Cleanup old data file: {}!", (Object)firstFile.getName());
            }
            this.files.getDataFiles().add(this.currentFile);
            this.currentFileRecordsCount = 0L;
            try {
                if (this.bufferedWriter != null) {
                    this.bufferedWriter.close();
                }
            }
            catch (IOException e) {
                log.warn("Failed to close buffered writer!", (Throwable)e);
                if (callback != null) {
                    callback.onError((Throwable)e);
                }
                return;
            }
            this.bufferedWriter = null;
        }
        String encoded = Base64.getEncoder().encodeToString(msg.toByteArray());
        try {
            BufferedWriter writer = this.getOrInitBufferedWriter(this.currentFile);
            writer.write(encoded);
            writer.newLine();
            log.debug("Record written to: [{}:{}]", (Object)this.currentFile.getName(), (Object)this.currentFileRecordsCount);
            ++this.currentFileRecordsCount;
            if (this.currentFileRecordsCount % (long)this.settings.getMaxRecordsBetweenFsync() == 0L) {
                log.debug("Executing flush of the full pack!");
                writer.flush();
                this.newRecordAfterFlush = false;
            }
        }
        catch (IOException e) {
            log.warn("Failed to update data file![{}]", (Object)this.currentFile.getName(), (Object)e);
            if (callback != null) {
                callback.onError((Throwable)e);
            }
            return;
        }
        if (callback != null) {
            callback.onSuccess(null);
        }
    }

    void flushIfNeeded() {
        if (this.newRecordAfterFlush && this.bufferedWriter != null) {
            try {
                log.debug("Executing flush of the temporary pack!");
                this.bufferedWriter.flush();
                this.newRecordAfterFlush = false;
            }
            catch (IOException e) {
                log.warn("Failed to update data file![{}]", (Object)this.currentFile.getName(), (Object)e);
            }
        }
    }

    private BufferedWriter getOrInitBufferedWriter(File file) {
        try {
            if (this.bufferedWriter == null) {
                this.bufferedWriter = new BufferedWriter(new FileWriter(file, true));
            }
            return this.bufferedWriter;
        }
        catch (IOException e) {
            log.error("Failed to initialize buffered writer!", (Throwable)e);
            throw new RuntimeException("Failed to initialize buffered writer!", e);
        }
    }

    private File createDataFile(String fileName) throws IOException {
        return Files.createFile(Paths.get(this.settings.getDataFolderPath() + "/data_" + fileName + ".txt", new String[0]), new FileAttribute[0]).toFile();
    }

    private long getNumberOfRecordsInFile(File file) {
        if (this.currentFileRecordsCount == 0L) {
            try {
                this.currentFileRecordsCount = Files.lines(Paths.get(file.toURI())).count();
            }
            catch (IOException e) {
                log.warn("Could not get the records count from the file![{}]", (Object)file.getName());
            }
        }
        return this.currentFileRecordsCount;
    }

    private boolean isFileFull(long currentFileSize) {
        return currentFileSize >= (long)this.settings.getMaxRecordsPerFile();
    }

    void destroy() throws IOException {
        if (this.bufferedWriter != null) {
            this.bufferedWriter.close();
        }
    }

    public EventStorageFiles getFiles() {
        return this.files;
    }

    public FileEventStorageSettings getSettings() {
        return this.settings;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public long getCurrentFileRecordsCount() {
        return this.currentFileRecordsCount;
    }

    public BufferedWriter getBufferedWriter() {
        return this.bufferedWriter;
    }

    public boolean isNewRecordAfterFlush() {
        return this.newRecordAfterFlush;
    }

    public void setFiles(EventStorageFiles files) {
        this.files = files;
    }

    public void setSettings(FileEventStorageSettings settings) {
        this.settings = settings;
    }

    public void setCurrentFile(File currentFile) {
        this.currentFile = currentFile;
    }

    public void setCurrentFileRecordsCount(long currentFileRecordsCount) {
        this.currentFileRecordsCount = currentFileRecordsCount;
    }

    public void setBufferedWriter(BufferedWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
    }

    public void setNewRecordAfterFlush(boolean newRecordAfterFlush) {
        this.newRecordAfterFlush = newRecordAfterFlush;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventStorageWriter)) {
            return false;
        }
        EventStorageWriter other = (EventStorageWriter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentFileRecordsCount() != other.getCurrentFileRecordsCount()) {
            return false;
        }
        if (this.isNewRecordAfterFlush() != other.isNewRecordAfterFlush()) {
            return false;
        }
        EventStorageFiles this$files = this.getFiles();
        EventStorageFiles other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        FileEventStorageSettings this$settings = this.getSettings();
        FileEventStorageSettings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        File this$currentFile = this.getCurrentFile();
        File other$currentFile = other.getCurrentFile();
        if (this$currentFile == null ? other$currentFile != null : !((Object)this$currentFile).equals(other$currentFile)) {
            return false;
        }
        BufferedWriter this$bufferedWriter = this.getBufferedWriter();
        BufferedWriter other$bufferedWriter = other.getBufferedWriter();
        return !(this$bufferedWriter == null ? other$bufferedWriter != null : !this$bufferedWriter.equals(other$bufferedWriter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventStorageWriter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $currentFileRecordsCount = this.getCurrentFileRecordsCount();
        result = result * 59 + (int)($currentFileRecordsCount >>> 32 ^ $currentFileRecordsCount);
        result = result * 59 + (this.isNewRecordAfterFlush() ? 79 : 97);
        EventStorageFiles $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        FileEventStorageSettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        File $currentFile = this.getCurrentFile();
        result = result * 59 + ($currentFile == null ? 43 : ((Object)$currentFile).hashCode());
        BufferedWriter $bufferedWriter = this.getBufferedWriter();
        result = result * 59 + ($bufferedWriter == null ? 43 : $bufferedWriter.hashCode());
        return result;
    }

    public String toString() {
        return "EventStorageWriter(files=" + this.getFiles() + ", settings=" + this.getSettings() + ", currentFile=" + this.getCurrentFile() + ", currentFileRecordsCount=" + this.getCurrentFileRecordsCount() + ", bufferedWriter=" + this.getBufferedWriter() + ", newRecordAfterFlush=" + this.isNewRecordAfterFlush() + ")";
    }
}

