/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.storage;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.integration.storage.EventStorageFiles;
import org.thingsboard.integration.storage.EventStorageReaderPointer;
import org.thingsboard.integration.storage.FileEventStorageSettings;
import org.thingsboard.server.gen.integration.UplinkMsg;

class EventStorageReader {
    private static final Logger log = LoggerFactory.getLogger(EventStorageReader.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private EventStorageFiles files;
    private FileEventStorageSettings settings;
    private BufferedReader bufferedReader;
    private volatile EventStorageReaderPointer currentPos;
    private volatile EventStorageReaderPointer newPos;
    private List<UplinkMsg> currentBatch;

    EventStorageReader(EventStorageFiles files, FileEventStorageSettings settings) {
        this.files = files;
        this.settings = settings;
        this.currentPos = this.readStateFile();
        this.newPos = this.currentPos.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UplinkMsg> read() {
        log.debug("[{}:{}] Check for new messages in storage", (Object)this.newPos.getFile(), (Object)this.newPos.getLine());
        if (this.currentBatch != null && !this.currentPos.equals(this.newPos)) {
            log.debug("The previous batch was not discarded!");
            return this.currentBatch;
        }
        this.currentBatch = new ArrayList<UplinkMsg>();
        int recordsToRead = this.settings.getMaxReadRecordsCount();
        while (recordsToRead > 0) {
            try {
                File nextFile;
                String line;
                int currentLineInFile = this.newPos.getLine();
                BufferedReader reader = this.getOrInitBufferedReader(this.newPos);
                while ((line = reader.readLine()) != null) {
                    try {
                        this.currentBatch.add(UplinkMsg.parseFrom((byte[])Base64.getDecoder().decode(line)));
                        --recordsToRead;
                    }
                    catch (Exception e) {
                        log.warn("Could not parse line [{}] to uplink message!", (Object)line, (Object)e);
                    }
                    finally {
                        ++currentLineInFile;
                    }
                    this.newPos.setLine(currentLineInFile);
                    if (recordsToRead != 0) continue;
                }
                if (currentLineInFile != this.settings.getMaxRecordsPerFile() || (nextFile = this.getNextFile(this.files, this.newPos)) == null) break;
                if (this.bufferedReader != null) {
                    this.bufferedReader.close();
                }
                this.bufferedReader = null;
                this.newPos = new EventStorageReaderPointer(nextFile, 0);
            }
            catch (IOException e) {
                log.warn("[{}] Failed to read file!", (Object)this.newPos.getFile().getName(), (Object)e);
                break;
            }
        }
        log.debug("Got {} mesages from storage", (Object)this.currentBatch.size());
        return this.currentBatch;
    }

    void discardBatch() {
        this.currentPos = this.newPos.copy();
        this.writeInfoToStateFile(this.currentPos);
    }

    private File getNextFile(EventStorageFiles files, EventStorageReaderPointer newPos) {
        boolean found = false;
        for (File file : files.getDataFiles()) {
            if (found) {
                return file;
            }
            if (!file.getName().equals(newPos.getFile().getName())) continue;
            found = true;
        }
        if (found) {
            return null;
        }
        return files.getDataFiles().get(0);
    }

    private BufferedReader getOrInitBufferedReader(EventStorageReaderPointer pointer) {
        try {
            if (this.bufferedReader == null) {
                this.bufferedReader = Files.newBufferedReader(pointer.getFile().toPath());
                int linesToSkip = pointer.getLine();
                if (linesToSkip > 0) {
                    while (linesToSkip != 0 && this.bufferedReader.readLine() != null) {
                        --linesToSkip;
                    }
                }
            }
            return this.bufferedReader;
        }
        catch (IOException e) {
            log.error("Failed to initialize buffered reader!", (Throwable)e);
            throw new RuntimeException("Failed to initialize buffered reader!", e);
        }
    }

    private EventStorageReaderPointer readStateFile() {
        JsonNode stateDataNode = null;
        try (BufferedReader br = Files.newBufferedReader(this.files.getStateFile().toPath());){
            stateDataNode = mapper.readTree((Reader)br);
        }
        catch (IOException e) {
            log.warn("Failed to fetch info from state file!", (Throwable)e);
        }
        File readerFile = null;
        int readerPos = 0;
        if (stateDataNode != null && stateDataNode.has("position") && stateDataNode.has("file")) {
            readerPos = stateDataNode.get("position").asInt();
            for (File file : this.files.getDataFiles()) {
                if (!file.getName().equals(stateDataNode.get("file").asText())) continue;
                readerFile = file;
                break;
            }
        }
        if (readerFile == null) {
            readerFile = this.files.getDataFiles().get(0);
            readerPos = 0;
        }
        log.info("Initializing from state file: [{}:{}]", (Object)readerFile.getAbsolutePath(), (Object)readerPos);
        return new EventStorageReaderPointer(readerFile, readerPos);
    }

    private void writeInfoToStateFile(EventStorageReaderPointer pointer) {
        try {
            ObjectNode stateFileNode = mapper.createObjectNode();
            stateFileNode.put("position", pointer.getLine());
            stateFileNode.put("file", pointer.getFile().getName());
            Files.write(Paths.get(this.files.getStateFile().toURI()), mapper.writeValueAsString((Object)stateFileNode).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            log.warn("Failed to update state file!", (Throwable)e);
        }
    }

    void destroy() throws IOException {
        if (this.bufferedReader != null) {
            this.bufferedReader.close();
        }
    }

    public EventStorageFiles getFiles() {
        return this.files;
    }

    public FileEventStorageSettings getSettings() {
        return this.settings;
    }

    public BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    public EventStorageReaderPointer getCurrentPos() {
        return this.currentPos;
    }

    public EventStorageReaderPointer getNewPos() {
        return this.newPos;
    }

    public List<UplinkMsg> getCurrentBatch() {
        return this.currentBatch;
    }

    public void setFiles(EventStorageFiles files) {
        this.files = files;
    }

    public void setSettings(FileEventStorageSettings settings) {
        this.settings = settings;
    }

    public void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    public void setCurrentPos(EventStorageReaderPointer currentPos) {
        this.currentPos = currentPos;
    }

    public void setNewPos(EventStorageReaderPointer newPos) {
        this.newPos = newPos;
    }

    public void setCurrentBatch(List<UplinkMsg> currentBatch) {
        this.currentBatch = currentBatch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventStorageReader)) {
            return false;
        }
        EventStorageReader other = (EventStorageReader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventStorageFiles this$files = this.getFiles();
        EventStorageFiles other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        FileEventStorageSettings this$settings = this.getSettings();
        FileEventStorageSettings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        BufferedReader this$bufferedReader = this.getBufferedReader();
        BufferedReader other$bufferedReader = other.getBufferedReader();
        if (this$bufferedReader == null ? other$bufferedReader != null : !this$bufferedReader.equals(other$bufferedReader)) {
            return false;
        }
        EventStorageReaderPointer this$currentPos = this.getCurrentPos();
        EventStorageReaderPointer other$currentPos = other.getCurrentPos();
        if (this$currentPos == null ? other$currentPos != null : !((Object)this$currentPos).equals(other$currentPos)) {
            return false;
        }
        EventStorageReaderPointer this$newPos = this.getNewPos();
        EventStorageReaderPointer other$newPos = other.getNewPos();
        if (this$newPos == null ? other$newPos != null : !((Object)this$newPos).equals(other$newPos)) {
            return false;
        }
        List<UplinkMsg> this$currentBatch = this.getCurrentBatch();
        List<UplinkMsg> other$currentBatch = other.getCurrentBatch();
        return !(this$currentBatch == null ? other$currentBatch != null : !((Object)this$currentBatch).equals(other$currentBatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventStorageReader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventStorageFiles $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        FileEventStorageSettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        BufferedReader $bufferedReader = this.getBufferedReader();
        result = result * 59 + ($bufferedReader == null ? 43 : $bufferedReader.hashCode());
        EventStorageReaderPointer $currentPos = this.getCurrentPos();
        result = result * 59 + ($currentPos == null ? 43 : ((Object)$currentPos).hashCode());
        EventStorageReaderPointer $newPos = this.getNewPos();
        result = result * 59 + ($newPos == null ? 43 : ((Object)$newPos).hashCode());
        List<UplinkMsg> $currentBatch = this.getCurrentBatch();
        result = result * 59 + ($currentBatch == null ? 43 : ((Object)$currentBatch).hashCode());
        return result;
    }

    public String toString() {
        return "EventStorageReader(files=" + this.getFiles() + ", settings=" + this.getSettings() + ", bufferedReader=" + this.getBufferedReader() + ", currentPos=" + this.getCurrentPos() + ", newPos=" + this.getNewPos() + ", currentBatch=" + this.getCurrentBatch() + ")";
    }
}

