/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.remote;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.integration.api.IntegrationControllerApi;
import org.thingsboard.integration.api.ThingsboardPlatformIntegration;
import org.thingsboard.integration.service.RemoteIntegrationManagerService;
import org.thingsboard.server.queue.util.TbIntegrationComponent;

@TbIntegrationComponent
@Component
public class RemoteIntegrationControllerApi
implements IntegrationControllerApi {
    private ListeningExecutorService service;
    @Value(value="${executors.thread_pool_size}")
    private int executorThreadPoolSize;
    @Autowired
    private RemoteIntegrationManagerService managerService;

    @PostConstruct
    public void init() {
        this.service = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)this.executorThreadPoolSize, this.getClass()));
    }

    @PreDestroy
    public void destroy() {
        if (this.service != null) {
            this.service.shutdown();
        }
    }

    public ListenableFuture<ThingsboardPlatformIntegration> getIntegrationByRoutingKey(String routingKey) {
        return Futures.immediateFuture((Object)this.managerService.getIntegration());
    }

    public <T> void process(ThingsboardPlatformIntegration<T> integration, T msg) {
        integration.process(msg);
    }

    public Executor getCallbackExecutor() {
        return this.service;
    }

    public ListeningExecutorService getService() {
        return this.service;
    }

    public int getExecutorThreadPoolSize() {
        return this.executorThreadPoolSize;
    }

    public RemoteIntegrationManagerService getManagerService() {
        return this.managerService;
    }

    public void setService(ListeningExecutorService service) {
        this.service = service;
    }

    public void setExecutorThreadPoolSize(int executorThreadPoolSize) {
        this.executorThreadPoolSize = executorThreadPoolSize;
    }

    public void setManagerService(RemoteIntegrationManagerService managerService) {
        this.managerService = managerService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteIntegrationControllerApi)) {
            return false;
        }
        RemoteIntegrationControllerApi other = (RemoteIntegrationControllerApi)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExecutorThreadPoolSize() != other.getExecutorThreadPoolSize()) {
            return false;
        }
        ListeningExecutorService this$service = this.getService();
        ListeningExecutorService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        RemoteIntegrationManagerService this$managerService = this.getManagerService();
        RemoteIntegrationManagerService other$managerService = other.getManagerService();
        return !(this$managerService == null ? other$managerService != null : !((Object)this$managerService).equals(other$managerService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteIntegrationControllerApi;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExecutorThreadPoolSize();
        ListeningExecutorService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        RemoteIntegrationManagerService $managerService = this.getManagerService();
        result = result * 59 + ($managerService == null ? 43 : ((Object)$managerService).hashCode());
        return result;
    }

    public String toString() {
        return "RemoteIntegrationControllerApi(service=" + this.getService() + ", executorThreadPoolSize=" + this.getExecutorThreadPoolSize() + ", managerService=" + this.getManagerService() + ")";
    }
}

