/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.remote;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.IntegrationContext;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.data.DownLinkMsg;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.integration.remote.RemoteConverterContext;
import org.thingsboard.integration.storage.EventStorage;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.gen.integration.AssetUplinkDataProto;
import org.thingsboard.server.gen.integration.DeviceUplinkDataProto;
import org.thingsboard.server.gen.integration.EntityViewDataProto;
import org.thingsboard.server.gen.integration.TbEventProto;
import org.thingsboard.server.gen.integration.TbEventSource;
import org.thingsboard.server.gen.integration.UplinkMsg;

public class RemoteIntegrationContext
implements IntegrationContext {
    private static final Logger log = LoggerFactory.getLogger(RemoteIntegrationContext.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String REMOTE_INTEGRATION_CACHE = "remoteIntegration";
    protected final EventStorage eventStorage;
    protected final Integration configuration;
    protected final String clientId;
    protected final int port;
    protected final ConverterContext uplinkConverterContext;
    protected final ConverterContext downlinkConverterContext;
    protected final ScheduledExecutorService scheduledExecutorService;

    public RemoteIntegrationContext(EventStorage eventStorage, ScheduledExecutorService scheduledExecutorService, Integration configuration, String clientId, int port) {
        this.eventStorage = eventStorage;
        this.configuration = configuration;
        this.clientId = clientId;
        this.port = port;
        this.uplinkConverterContext = new RemoteConverterContext(eventStorage, true, mapper, clientId, port);
        this.downlinkConverterContext = new RemoteConverterContext(eventStorage, false, mapper, clientId, port);
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public String getServiceId() {
        return "[" + this.clientId + ":" + this.port + "]";
    }

    public void processUplinkData(DeviceUplinkDataProto msg, IntegrationCallback<Void> callback) {
        this.eventStorage.write(UplinkMsg.newBuilder().addDeviceData(msg).build(), callback);
    }

    public void processUplinkData(AssetUplinkDataProto msg, IntegrationCallback<Void> callback) {
        this.eventStorage.write(UplinkMsg.newBuilder().addAssetData(msg).build(), callback);
    }

    public void createEntityView(EntityViewDataProto msg, IntegrationCallback<Void> callback) {
        this.eventStorage.write(UplinkMsg.newBuilder().addEntityViewData(msg).build(), callback);
    }

    public void processCustomMsg(TbMsg msg, IntegrationCallback<Void> callback) {
        this.eventStorage.write(UplinkMsg.newBuilder().addTbMsg(TbMsg.toByteString((TbMsg)msg)).build(), callback);
    }

    public void saveEvent(String type, String uid, JsonNode body, IntegrationCallback<Void> callback) {
        this.saveEvent(TbEventSource.INTEGRATION, "", type, uid, body, callback);
    }

    public void saveRawDataEvent(String deviceName, String type, String uid, JsonNode body, IntegrationCallback<Void> callback) {
        this.saveEvent(TbEventSource.DEVICE, deviceName, type, uid, body, callback);
    }

    public EventLoopGroup getEventLoopGroup() {
        return null;
    }

    public DownLinkMsg getDownlinkMsg(String deviceName) {
        return null;
    }

    public DownLinkMsg putDownlinkMsg(IntegrationDownlinkMsg msg) {
        return null;
    }

    public void removeDownlinkMsg(String deviceName) {
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public boolean isClosed() {
        return false;
    }

    private void saveEvent(TbEventSource tbEventSource, String deviceName, String type, String uid, JsonNode body, IntegrationCallback<Void> callback) {
        String eventData = "";
        try {
            eventData = mapper.writeValueAsString((Object)body);
        }
        catch (JsonProcessingException e) {
            log.warn("[{}] Failed to convert event body!", (Object)body, (Object)e);
        }
        this.eventStorage.write(UplinkMsg.newBuilder().addEventsData(TbEventProto.newBuilder().setSource(tbEventSource).setType(type).setUid(uid).setData(eventData).setDeviceName(deviceName).build()).build(), callback);
    }

    public EventStorage getEventStorage() {
        return this.eventStorage;
    }

    public Integration getConfiguration() {
        return this.configuration;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getPort() {
        return this.port;
    }

    public ConverterContext getUplinkConverterContext() {
        return this.uplinkConverterContext;
    }

    public ConverterContext getDownlinkConverterContext() {
        return this.downlinkConverterContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteIntegrationContext)) {
            return false;
        }
        RemoteIntegrationContext other = (RemoteIntegrationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventStorage this$eventStorage = this.getEventStorage();
        EventStorage other$eventStorage = other.getEventStorage();
        if (this$eventStorage == null ? other$eventStorage != null : !this$eventStorage.equals(other$eventStorage)) {
            return false;
        }
        Integration this$configuration = this.getConfiguration();
        Integration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        ConverterContext this$uplinkConverterContext = this.getUplinkConverterContext();
        ConverterContext other$uplinkConverterContext = other.getUplinkConverterContext();
        if (this$uplinkConverterContext == null ? other$uplinkConverterContext != null : !this$uplinkConverterContext.equals(other$uplinkConverterContext)) {
            return false;
        }
        ConverterContext this$downlinkConverterContext = this.getDownlinkConverterContext();
        ConverterContext other$downlinkConverterContext = other.getDownlinkConverterContext();
        if (this$downlinkConverterContext == null ? other$downlinkConverterContext != null : !this$downlinkConverterContext.equals(other$downlinkConverterContext)) {
            return false;
        }
        ScheduledExecutorService this$scheduledExecutorService = this.getScheduledExecutorService();
        ScheduledExecutorService other$scheduledExecutorService = other.getScheduledExecutorService();
        return !(this$scheduledExecutorService == null ? other$scheduledExecutorService != null : !this$scheduledExecutorService.equals(other$scheduledExecutorService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteIntegrationContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventStorage $eventStorage = this.getEventStorage();
        result = result * 59 + ($eventStorage == null ? 43 : $eventStorage.hashCode());
        Integration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        result = result * 59 + this.getPort();
        ConverterContext $uplinkConverterContext = this.getUplinkConverterContext();
        result = result * 59 + ($uplinkConverterContext == null ? 43 : $uplinkConverterContext.hashCode());
        ConverterContext $downlinkConverterContext = this.getDownlinkConverterContext();
        result = result * 59 + ($downlinkConverterContext == null ? 43 : $downlinkConverterContext.hashCode());
        ScheduledExecutorService $scheduledExecutorService = this.getScheduledExecutorService();
        result = result * 59 + ($scheduledExecutorService == null ? 43 : $scheduledExecutorService.hashCode());
        return result;
    }

    public String toString() {
        return "RemoteIntegrationContext(eventStorage=" + this.getEventStorage() + ", configuration=" + this.getConfiguration() + ", clientId=" + this.getClientId() + ", port=" + this.getPort() + ", uplinkConverterContext=" + this.getUplinkConverterContext() + ", downlinkConverterContext=" + this.getDownlinkConverterContext() + ", scheduledExecutorService=" + this.getScheduledExecutorService() + ")";
    }
}

