/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.storage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileEventStorageSettings {
    private static final Logger log = LoggerFactory.getLogger(FileEventStorageSettings.class);
    @Value(value="${storage.data_folder_path}")
    private String dataFolderPath;
    @Value(value="${storage.max_file_count}")
    private int maxFileCount;
    @Value(value="${storage.max_records_per_file}")
    private int maxRecordsPerFile;
    @Value(value="${storage.max_records_between_fsync}")
    private int maxRecordsBetweenFsync;
    @Value(value="${storage.max_read_records_count}")
    private int maxReadRecordsCount;
    @Value(value="${storage.no_read_records_sleep}")
    private long noRecordsSleepInterval;

    public String getDataFolderPath() {
        return this.dataFolderPath;
    }

    public int getMaxFileCount() {
        return this.maxFileCount;
    }

    public int getMaxRecordsPerFile() {
        return this.maxRecordsPerFile;
    }

    public int getMaxRecordsBetweenFsync() {
        return this.maxRecordsBetweenFsync;
    }

    public int getMaxReadRecordsCount() {
        return this.maxReadRecordsCount;
    }

    public long getNoRecordsSleepInterval() {
        return this.noRecordsSleepInterval;
    }

    public void setDataFolderPath(String dataFolderPath) {
        this.dataFolderPath = dataFolderPath;
    }

    public void setMaxFileCount(int maxFileCount) {
        this.maxFileCount = maxFileCount;
    }

    public void setMaxRecordsPerFile(int maxRecordsPerFile) {
        this.maxRecordsPerFile = maxRecordsPerFile;
    }

    public void setMaxRecordsBetweenFsync(int maxRecordsBetweenFsync) {
        this.maxRecordsBetweenFsync = maxRecordsBetweenFsync;
    }

    public void setMaxReadRecordsCount(int maxReadRecordsCount) {
        this.maxReadRecordsCount = maxReadRecordsCount;
    }

    public void setNoRecordsSleepInterval(long noRecordsSleepInterval) {
        this.noRecordsSleepInterval = noRecordsSleepInterval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileEventStorageSettings)) {
            return false;
        }
        FileEventStorageSettings other = (FileEventStorageSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dataFolderPath = this.getDataFolderPath();
        String other$dataFolderPath = other.getDataFolderPath();
        if (this$dataFolderPath == null ? other$dataFolderPath != null : !this$dataFolderPath.equals(other$dataFolderPath)) {
            return false;
        }
        if (this.getMaxFileCount() != other.getMaxFileCount()) {
            return false;
        }
        if (this.getMaxRecordsPerFile() != other.getMaxRecordsPerFile()) {
            return false;
        }
        if (this.getMaxRecordsBetweenFsync() != other.getMaxRecordsBetweenFsync()) {
            return false;
        }
        if (this.getMaxReadRecordsCount() != other.getMaxReadRecordsCount()) {
            return false;
        }
        return this.getNoRecordsSleepInterval() == other.getNoRecordsSleepInterval();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileEventStorageSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dataFolderPath = this.getDataFolderPath();
        result = result * 59 + ($dataFolderPath == null ? 43 : $dataFolderPath.hashCode());
        result = result * 59 + this.getMaxFileCount();
        result = result * 59 + this.getMaxRecordsPerFile();
        result = result * 59 + this.getMaxRecordsBetweenFsync();
        result = result * 59 + this.getMaxReadRecordsCount();
        long $noRecordsSleepInterval = this.getNoRecordsSleepInterval();
        result = result * 59 + (int)($noRecordsSleepInterval >>> 32 ^ $noRecordsSleepInterval);
        return result;
    }

    public String toString() {
        return "FileEventStorageSettings(dataFolderPath=" + this.getDataFolderPath() + ", maxFileCount=" + this.getMaxFileCount() + ", maxRecordsPerFile=" + this.getMaxRecordsPerFile() + ", maxRecordsBetweenFsync=" + this.getMaxRecordsBetweenFsync() + ", maxReadRecordsCount=" + this.getMaxReadRecordsCount() + ", noRecordsSleepInterval=" + this.getNoRecordsSleepInterval() + ")";
    }
}

