/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.storage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.storage.EventStorage;
import org.thingsboard.integration.storage.EventStorageFiles;
import org.thingsboard.integration.storage.EventStorageReader;
import org.thingsboard.integration.storage.EventStorageWriter;
import org.thingsboard.integration.storage.FileEventStorageSettings;
import org.thingsboard.server.gen.integration.UplinkMsg;

@Component
public class FileEventStorage
implements EventStorage {
    private static final Logger log = LoggerFactory.getLogger(FileEventStorage.class);
    @Autowired
    private FileEventStorageSettings settings;
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();
    private List<File> dataFiles;
    private File stateFile;
    private EventStorageWriter storageWriter;
    private EventStorageReader storageReader;

    @PostConstruct
    public void init() {
        this.initDataFolderIfNotExist();
        EventStorageFiles eventStorageFiles = this.initDataFiles();
        this.dataFiles = eventStorageFiles.getDataFiles();
        this.stateFile = eventStorageFiles.getStateFile();
        this.storageWriter = new EventStorageWriter(eventStorageFiles, this.settings);
        this.storageReader = new EventStorageReader(eventStorageFiles, this.settings);
    }

    @PreDestroy
    public void destroy() throws IOException {
        this.storageReader.destroy();
        this.storageWriter.destroy();
    }

    @Override
    public void write(UplinkMsg msg, IntegrationCallback<Void> callback) {
        this.writeLock.lock();
        try {
            this.storageWriter.write(msg, callback);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public List<UplinkMsg> readCurrentBatch() {
        this.writeLock.lock();
        try {
            this.storageWriter.flushIfNeeded();
        }
        finally {
            this.writeLock.unlock();
        }
        this.readLock.lock();
        try {
            List<UplinkMsg> list = this.storageReader.read();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void discardCurrentBatch() {
        this.readLock.lock();
        try {
            this.storageReader.discardBatch();
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void sleep() {
        try {
            Thread.sleep(this.settings.getNoRecordsSleepInterval());
        }
        catch (InterruptedException e) {
            log.warn("Failed to sleep a bit", (Throwable)e);
        }
    }

    private void initDataFolderIfNotExist() {
        Path path = Paths.get(this.settings.getDataFolderPath(), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create data folder!", e);
            }
        }
    }

    private EventStorageFiles initDataFiles() {
        CopyOnWriteArrayList<File> dataFiles = new CopyOnWriteArrayList<File>();
        File stateFile = null;
        File dir = new File(this.settings.getDataFolderPath());
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.getName().startsWith("data_")) {
                    dataFiles.add(file);
                    continue;
                }
                if (!file.getName().startsWith("state_")) continue;
                stateFile = file;
            }
            Collections.sort(dataFiles);
            if (dataFiles.size() == 0) {
                dataFiles.add(this.createNewDataFile());
            }
            if (stateFile == null) {
                stateFile = this.createFile("/state_", "file");
            }
            return new EventStorageFiles(stateFile, dataFiles);
        }
        log.error("[{}] The specified path is not referred to the directory!", (Object)this.settings.getDataFolderPath());
        throw new RuntimeException("The specified path is not referred to the directory! " + this.settings.getDataFolderPath());
    }

    private File createNewDataFile() {
        return this.createFile("/data_", Long.toString(System.currentTimeMillis()));
    }

    private File createFile(String prefix, String fileName) {
        Path filePath = Paths.get(this.settings.getDataFolderPath() + prefix + fileName + ".txt", new String[0]);
        try {
            return Files.createFile(filePath, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a new file!", e);
        }
    }

    public FileEventStorageSettings getSettings() {
        return this.settings;
    }

    public ReentrantLock getReadLock() {
        return this.readLock;
    }

    public ReentrantLock getWriteLock() {
        return this.writeLock;
    }

    public List<File> getDataFiles() {
        return this.dataFiles;
    }

    public File getStateFile() {
        return this.stateFile;
    }

    public EventStorageWriter getStorageWriter() {
        return this.storageWriter;
    }

    public EventStorageReader getStorageReader() {
        return this.storageReader;
    }

    public void setSettings(FileEventStorageSettings settings) {
        this.settings = settings;
    }

    public void setDataFiles(List<File> dataFiles) {
        this.dataFiles = dataFiles;
    }

    public void setStateFile(File stateFile) {
        this.stateFile = stateFile;
    }

    public void setStorageWriter(EventStorageWriter storageWriter) {
        this.storageWriter = storageWriter;
    }

    public void setStorageReader(EventStorageReader storageReader) {
        this.storageReader = storageReader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileEventStorage)) {
            return false;
        }
        FileEventStorage other = (FileEventStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileEventStorageSettings this$settings = this.getSettings();
        FileEventStorageSettings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        ReentrantLock this$readLock = this.getReadLock();
        ReentrantLock other$readLock = other.getReadLock();
        if (this$readLock == null ? other$readLock != null : !this$readLock.equals(other$readLock)) {
            return false;
        }
        ReentrantLock this$writeLock = this.getWriteLock();
        ReentrantLock other$writeLock = other.getWriteLock();
        if (this$writeLock == null ? other$writeLock != null : !this$writeLock.equals(other$writeLock)) {
            return false;
        }
        List<File> this$dataFiles = this.getDataFiles();
        List<File> other$dataFiles = other.getDataFiles();
        if (this$dataFiles == null ? other$dataFiles != null : !((Object)this$dataFiles).equals(other$dataFiles)) {
            return false;
        }
        File this$stateFile = this.getStateFile();
        File other$stateFile = other.getStateFile();
        if (this$stateFile == null ? other$stateFile != null : !((Object)this$stateFile).equals(other$stateFile)) {
            return false;
        }
        EventStorageWriter this$storageWriter = this.getStorageWriter();
        EventStorageWriter other$storageWriter = other.getStorageWriter();
        if (this$storageWriter == null ? other$storageWriter != null : !((Object)this$storageWriter).equals(other$storageWriter)) {
            return false;
        }
        EventStorageReader this$storageReader = this.getStorageReader();
        EventStorageReader other$storageReader = other.getStorageReader();
        return !(this$storageReader == null ? other$storageReader != null : !((Object)this$storageReader).equals(other$storageReader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileEventStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileEventStorageSettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        ReentrantLock $readLock = this.getReadLock();
        result = result * 59 + ($readLock == null ? 43 : $readLock.hashCode());
        ReentrantLock $writeLock = this.getWriteLock();
        result = result * 59 + ($writeLock == null ? 43 : $writeLock.hashCode());
        List<File> $dataFiles = this.getDataFiles();
        result = result * 59 + ($dataFiles == null ? 43 : ((Object)$dataFiles).hashCode());
        File $stateFile = this.getStateFile();
        result = result * 59 + ($stateFile == null ? 43 : ((Object)$stateFile).hashCode());
        EventStorageWriter $storageWriter = this.getStorageWriter();
        result = result * 59 + ($storageWriter == null ? 43 : ((Object)$storageWriter).hashCode());
        EventStorageReader $storageReader = this.getStorageReader();
        result = result * 59 + ($storageReader == null ? 43 : ((Object)$storageReader).hashCode());
        return result;
    }

    public String toString() {
        return "FileEventStorage(settings=" + this.getSettings() + ", readLock=" + this.getReadLock() + ", writeLock=" + this.getWriteLock() + ", dataFiles=" + this.getDataFiles() + ", stateFile=" + this.getStateFile() + ", storageWriter=" + this.getStorageWriter() + ", storageReader=" + this.getStorageReader() + ")";
    }
}

