/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.remote;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.storage.EventStorage;
import org.thingsboard.server.common.msg.cluster.ServerAddress;
import org.thingsboard.server.common.msg.cluster.ServerType;
import org.thingsboard.server.gen.integration.TbEventProto;
import org.thingsboard.server.gen.integration.TbEventSource;
import org.thingsboard.server.gen.integration.UplinkMsg;

public class RemoteConverterContext
implements ConverterContext {
    private static final Logger log = LoggerFactory.getLogger(RemoteConverterContext.class);
    private final EventStorage eventStorage;
    private final boolean isUplink;
    private final ObjectMapper mapper;
    private final String clientId;
    private final int port;

    public ServerAddress getServerAddress() {
        return new ServerAddress(this.clientId, this.port, ServerType.CORE);
    }

    public void saveEvent(String type, JsonNode body, IntegrationCallback<Void> callback) {
        TbEventSource source = this.isUplink ? TbEventSource.UPLINK_CONVERTER : TbEventSource.DOWNLINK_CONVERTER;
        String eventData = "";
        try {
            eventData = this.mapper.writeValueAsString((Object)body);
        }
        catch (JsonProcessingException e) {
            log.warn("[{}] Failed to convert event body!", (Object)body, (Object)e);
        }
        this.eventStorage.write(UplinkMsg.newBuilder().addEventsData(TbEventProto.newBuilder().setSource(source).setType(type).setData(eventData).build()).build(), callback);
    }

    @ConstructorProperties(value={"eventStorage", "isUplink", "mapper", "clientId", "port"})
    public RemoteConverterContext(EventStorage eventStorage, boolean isUplink, ObjectMapper mapper, String clientId, int port) {
        this.eventStorage = eventStorage;
        this.isUplink = isUplink;
        this.mapper = mapper;
        this.clientId = clientId;
        this.port = port;
    }

    public EventStorage getEventStorage() {
        return this.eventStorage;
    }

    public boolean isUplink() {
        return this.isUplink;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteConverterContext)) {
            return false;
        }
        RemoteConverterContext other = (RemoteConverterContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventStorage this$eventStorage = this.getEventStorage();
        EventStorage other$eventStorage = other.getEventStorage();
        if (this$eventStorage == null ? other$eventStorage != null : !this$eventStorage.equals(other$eventStorage)) {
            return false;
        }
        if (this.isUplink() != other.isUplink()) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteConverterContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventStorage $eventStorage = this.getEventStorage();
        result = result * 59 + ($eventStorage == null ? 43 : $eventStorage.hashCode());
        result = result * 59 + (this.isUplink() ? 79 : 97);
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        result = result * 59 + this.getPort();
        return result;
    }

    public String toString() {
        return "RemoteConverterContext(eventStorage=" + this.getEventStorage() + ", isUplink=" + this.isUplink() + ", mapper=" + this.getMapper() + ", clientId=" + this.getClientId() + ", port=" + this.getPort() + ")";
    }
}

