/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter.wrapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.Base64;
import java.util.Map;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.wrapper.AbstractConverterUnwrapper;
import org.thingsboard.integration.api.data.ContentType;
import org.thingsboard.server.common.data.util.TbPair;

public class ThingsStackConverterUnwrapper
extends AbstractConverterUnwrapper {
    private static final ImmutableMap<String, String> KEYS_MAPPING = new ImmutableMap.Builder().put((Object)"deviceId", (Object)"/end_device_ids/device_id").put((Object)"applicationId", (Object)"/end_device_ids/application_ids/application_id").put((Object)"eui", (Object)"/end_device_ids/dev_eui").put((Object)"joinEui", (Object)"/end_device_ids/join_eui").put((Object)"devAddr", (Object)"/end_device_ids/dev_addr").put((Object)"correlationIds", (Object)"/correlation_ids").put((Object)"receivedAt", (Object)"/received_at").put((Object)"sessionKeyId", (Object)"/uplink_message/session_key_id").put((Object)"fPort", (Object)"/uplink_message/f_port").put((Object)"fCnt", (Object)"/uplink_message/f_cnt").put((Object)"data", (Object)"/uplink_message/frm_payload").put((Object)"decoded", (Object)"/uplink_message/decoded_payload").put((Object)"rxMetadata", (Object)"/uplink_message/rx_metadata").put((Object)"bandwidth", (Object)"/uplink_message/settings/data_rate/lora/bandwidth").put((Object)"spreadingFactor", (Object)"/uplink_message/settings/data_rate/lora/spreading_factor").put((Object)"dataRateIndex", (Object)"/uplink_message/settings/data_rate_index").put((Object)"codeRate", (Object)"/uplink_message/settings/coding_rate").put((Object)"frequency", (Object)"/uplink_message/settings/frequency").put((Object)"timestamp", (Object)"/uplink_message/settings/timestamp").put((Object)"time", (Object)"/uplink_message/settings/time").put((Object)"consumedAirtime", (Object)"/uplink_message/consumed_airtime").put((Object)"latitude", (Object)"/uplink_message/locations/user/latitude").put((Object)"longitude", (Object)"/uplink_message/locations/user/longitude").put((Object)"altitude", (Object)"/uplink_message/locations/user/altitude").put((Object)"source", (Object)"/uplink_message/locations/user/source").put((Object)"brandId", (Object)"/uplink_message/version_ids/brand_id").put((Object)"modelId", (Object)"/uplink_message/version_ids/model_id").put((Object)"hardwareVersion", (Object)"/uplink_message/version_ids/hardware_version").put((Object)"firmwareVersion", (Object)"/uplink_message/version_ids/firmware_version").put((Object)"bandId", (Object)"/uplink_message/version_ids/band_id").put((Object)"netId", (Object)"/uplink_message/network_ids/net_id").put((Object)"nsId", (Object)"/uplink_message/network_ids/ns_id").put((Object)"tenantId", (Object)"/uplink_message/network_ids/tenant_id").put((Object)"clusterId", (Object)"/uplink_message/network_ids/cluster_id").put((Object)"clusterAddress", (Object)"/uplink_message/network_ids/cluster_address").put((Object)"tenantAddress", (Object)"/uplink_message/network_ids/tenant_address").put((Object)"attributes", (Object)"/uplink_message/attributes").put((Object)"uplinkMessageReceivedAt", (Object)"/uplink_message/received_at").put((Object)"simulated", (Object)"/simulated").put((Object)"rssi", (Object)"").put((Object)"snr", (Object)"").build();

    @Override
    protected String getGatewayInfoPath() {
        return "/uplink_message/rx_metadata";
    }

    @Override
    protected TbPair<byte[], ContentType> getPayload(JsonNode payloadJson) {
        JsonNode uplink = payloadJson.get("uplink_message");
        if (uplink.has("decoded_payload")) {
            JsonNode decoded = uplink.get("decoded_payload");
            return TbPair.of((Object)JacksonUtil.writeValueAsBytes((Object)decoded), (Object)((Object)ContentType.JSON));
        }
        if (uplink.has("frm_payload")) {
            String data = uplink.get("frm_payload").textValue();
            return TbPair.of((Object)Base64.getDecoder().decode(data), (Object)((Object)ContentType.BINARY));
        }
        return TbPair.of((Object)EMPTY_BYTE_ARRAY, (Object)((Object)ContentType.BINARY));
    }

    @Override
    protected void postMapping(Map<String, Object> kvMap) {
        long ts = 0L;
        if (kvMap.containsKey("uplinkMessageReceivedAt")) {
            long uplinkMessageReceivedAtTs = this.parseDateToTimestamp(kvMap.get("uplinkMessageReceivedAt").toString());
            kvMap.put("uplinkMessageReceivedAtTs", uplinkMessageReceivedAtTs);
            ts = uplinkMessageReceivedAtTs;
        }
        if (kvMap.containsKey("time")) {
            long timeTs = this.parseDateToTimestamp(kvMap.get("time").toString());
            kvMap.put("timeTs", timeTs);
        }
        if (kvMap.containsKey("receivedAt")) {
            long receivedAtTs = this.parseDateToTimestamp(kvMap.get("receivedAt").toString());
            kvMap.put("receivedAtTs", receivedAtTs);
            if (ts == 0L) {
                ts = receivedAtTs;
            }
        }
        if (ts == 0L) {
            ts = System.currentTimeMillis();
        }
        kvMap.put("ts", ts);
    }

    @Override
    protected ImmutableMap<String, String> getKeysMapping() {
        return KEYS_MAPPING;
    }
}

