/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter.wrapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.wrapper.AbstractConverterUnwrapper;
import org.thingsboard.integration.api.data.ContentType;
import org.thingsboard.server.common.data.util.TbPair;

public class ThingParkConverterUnwrapper
extends AbstractConverterUnwrapper {
    private static final ImmutableMap<String, String> KEYS_MAPPING = new ImmutableMap.Builder().put((Object)"time", (Object)"/DevEUI_uplink/Time").put((Object)"eui", (Object)"/DevEUI_uplink/DevEUI").put((Object)"fPort", (Object)"/DevEUI_uplink/FPort").put((Object)"fCnt", (Object)"/DevEUI_uplink/FCntUp").put((Object)"lostUplinksAs", (Object)"/DevEUI_uplink/LostUplinksAS").put((Object)"adr", (Object)"/DevEUI_uplink/ADRbit").put((Object)"mType", (Object)"/DevEUI_uplink/MType").put((Object)"fCntDn", (Object)"/DevEUI_uplink/FCntDn").put((Object)"data", (Object)"/DevEUI_uplink/payload_hex").put((Object)"micHex", (Object)"/DevEUI_uplink/mic_hex").put((Object)"lrcid", (Object)"/DevEUI_uplink/Lrcid").put((Object)"rssi", (Object)"/DevEUI_uplink/LrrRSSI").put((Object)"snr", (Object)"/DevEUI_uplink/LrrSNR").put((Object)"esp", (Object)"/DevEUI_uplink/LrrESP").put((Object)"spreadingFactor", (Object)"/DevEUI_uplink/SpFact").put((Object)"bandwidth", (Object)"/DevEUI_uplink/SubBand").put((Object)"channel", (Object)"/DevEUI_uplink/Channel").put((Object)"lrrId", (Object)"/DevEUI_uplink/Lrrid").put((Object)"late", (Object)"/DevEUI_uplink/Late").put((Object)"latitude", (Object)"/DevEUI_uplink/LrrLAT").put((Object)"longitude", (Object)"/DevEUI_uplink/LrrLON").put((Object)"lrr", (Object)"/DevEUI_uplink/Lrrs/Lrr").put((Object)"devLrrCnt", (Object)"/DevEUI_uplink/DevLrrCnt").put((Object)"customerId", (Object)"/DevEUI_uplink/CustomerID").put((Object)"customerData", (Object)"/DevEUI_uplink/CustomerData").put((Object)"baseStationData", (Object)"/DevEUI_uplink/BaseStationData").put((Object)"modelCfg", (Object)"/DevEUI_uplink/ModelCfg").put((Object)"driverCfg", (Object)"/DevEUI_uplink/DriverCfg").put((Object)"instantPer", (Object)"/DevEUI_uplink/InstantPER").put((Object)"meanPer", (Object)"/DevEUI_uplink/MeanPER").put((Object)"devAddr", (Object)"/DevEUI_uplink/DevAddr").put((Object)"ackRequested", (Object)"/DevEUI_uplink/AckRequested").put((Object)"rawMacCommands", (Object)"/DevEUI_uplink/rawMacCommands").put((Object)"txPower", (Object)"/DevEUI_uplink/TxPower").put((Object)"nbTrans", (Object)"/DevEUI_uplink/NbTrans").put((Object)"frequency", (Object)"/DevEUI_uplink/Frequency").put((Object)"dynamicClass", (Object)"/DevEUI_uplink/DynamicClass").put((Object)"payloadEncryption", (Object)"/DevEUI_uplink/PayloadEncryption").put((Object)"decoded", (Object)"/DevEUI_uplink/payload").put((Object)"points", (Object)"/DevEUI_uplink/points").put((Object)"downlinkUrl", (Object)"/DevEUI_uplink/downlinkUrl").build();

    @Override
    protected TbPair<byte[], ContentType> getPayload(JsonNode payloadJson) throws DecoderException {
        JsonNode uplink = payloadJson.get("DevEUI_uplink");
        if (uplink.has("payload")) {
            JsonNode decoded = uplink.get("payload");
            return TbPair.of((Object)JacksonUtil.writeValueAsBytes((Object)decoded), (Object)((Object)ContentType.JSON));
        }
        if (uplink.has("payload_hex")) {
            String data = uplink.get("payload_hex").textValue();
            return TbPair.of((Object)Hex.decodeHex((char[])data.toCharArray()), (Object)((Object)ContentType.BINARY));
        }
        return TbPair.of((Object)EMPTY_BYTE_ARRAY, (Object)((Object)ContentType.BINARY));
    }

    @Override
    protected ImmutableMap<String, String> getKeysMapping() {
        return KEYS_MAPPING;
    }
}

