/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter.wrapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.wrapper.AbstractConverterUnwrapper;
import org.thingsboard.integration.api.data.ContentType;
import org.thingsboard.server.common.data.util.TbPair;

public class LoriotConverterUnwrapper
extends AbstractConverterUnwrapper {
    private static final ImmutableMap<String, String> KEYS_MAPPING = new ImmutableMap.Builder().put((Object)"cmd", (Object)"/cmd").put((Object)"seqno", (Object)"/seqno").put((Object)"eui", (Object)"/EUI").put((Object)"ts", (Object)"/ts").put((Object)"ack", (Object)"/ack").put((Object)"battery", (Object)"/bat").put((Object)"f\u0421nt", (Object)"/fcnt").put((Object)"fPort", (Object)"/port").put((Object)"offline", (Object)"/offline").put((Object)"frequency", (Object)"/freq").put((Object)"dr", (Object)"/dr").put((Object)"rssi", (Object)"/rssi").put((Object)"snr", (Object)"/snr").put((Object)"toa", (Object)"/toa").put((Object)"data", (Object)"/data").put((Object)"decoded", (Object)"/decoded").put((Object)"encdata", (Object)"/encdata").put((Object)"gws", (Object)"/gws").build();

    @Override
    protected String getGatewayInfoPath() {
        return "/gws";
    }

    @Override
    protected TbPair<byte[], ContentType> getPayload(JsonNode payloadJson) throws DecoderException {
        if (payloadJson.has("decoded")) {
            JsonNode decoded = payloadJson.get("decoded");
            return TbPair.of((Object)JacksonUtil.writeValueAsBytes((Object)decoded), (Object)((Object)ContentType.JSON));
        }
        if (payloadJson.has("data")) {
            String data = payloadJson.get("data").textValue();
            return TbPair.of((Object)Hex.decodeHex((char[])data.toCharArray()), (Object)((Object)ContentType.BINARY));
        }
        if (payloadJson.has("encdata")) {
            String encoded = payloadJson.get("encdata").textValue();
            return TbPair.of((Object)Hex.decodeHex((char[])encoded.toCharArray()), (Object)((Object)ContentType.BINARY));
        }
        return TbPair.of((Object)EMPTY_BYTE_ARRAY, (Object)((Object)ContentType.BINARY));
    }

    @Override
    protected void postMapping(Map<String, Object> kvMap) {
        if (!kvMap.containsKey("ts")) {
            kvMap.put("ts", System.currentTimeMillis());
        }
    }

    @Override
    protected ImmutableMap<String, String> getKeysMapping() {
        return KEYS_MAPPING;
    }
}

