/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter.wrapper;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.thingsboard.integration.api.converter.wrapper.ChirpStackConverterUnwrapper;
import org.thingsboard.integration.api.converter.wrapper.ConverterUnwrapper;
import org.thingsboard.integration.api.converter.wrapper.LoriotConverterUnwrapper;
import org.thingsboard.integration.api.converter.wrapper.ThingParkConverterUnwrapper;
import org.thingsboard.integration.api.converter.wrapper.ThingsStackConverterUnwrapper;
import org.thingsboard.server.common.data.integration.IntegrationType;

public final class ConverterUnwrapperFactory {
    private static final ConcurrentHashMap<IntegrationType, Optional<ConverterUnwrapper>> unwrappers = new ConcurrentHashMap();

    private ConverterUnwrapperFactory() {
    }

    public static Optional<ConverterUnwrapper> getUnwrapper(IntegrationType integrationType) {
        if (integrationType == null) {
            return Optional.empty();
        }
        return unwrappers.computeIfAbsent(integrationType, key -> Optional.ofNullable(switch (integrationType) {
            case IntegrationType.LORIOT -> new LoriotConverterUnwrapper();
            case IntegrationType.CHIRPSTACK -> new ChirpStackConverterUnwrapper();
            case IntegrationType.THINGPARK, IntegrationType.TPE -> new ThingParkConverterUnwrapper();
            case IntegrationType.TTN, IntegrationType.TTI -> new ThingsStackConverterUnwrapper();
            default -> null;
        }));
    }
}

