/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter.wrapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.Base64;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.wrapper.AbstractConverterUnwrapper;
import org.thingsboard.integration.api.data.ContentType;
import org.thingsboard.server.common.data.util.TbPair;

public class ChirpStackConverterUnwrapper
extends AbstractConverterUnwrapper {
    private static final ImmutableMap<String, String> KEYS_MAPPING = new ImmutableMap.Builder().put((Object)"deduplicationId", (Object)"/deduplicationId").put((Object)"time", (Object)"/time").put((Object)"tenantId", (Object)"/deviceInfo/tenantId").put((Object)"tenantName", (Object)"/deviceInfo/tenantName").put((Object)"applicationId", (Object)"/deviceInfo/applicationId").put((Object)"applicationName", (Object)"/deviceInfo/applicationName").put((Object)"deviceProfileId", (Object)"/deviceInfo/deviceProfileId").put((Object)"deviceProfileName", (Object)"/deviceInfo/deviceProfileName").put((Object)"deviceName", (Object)"/deviceInfo/deviceName").put((Object)"eui", (Object)"/deviceInfo/devEui").put((Object)"tags", (Object)"/deviceInfo/tags").put((Object)"devAddr", (Object)"/devAddr").put((Object)"adr", (Object)"/adr").put((Object)"dr", (Object)"/dr").put((Object)"fCnt", (Object)"/fCnt").put((Object)"fPort", (Object)"/fPort").put((Object)"confirmed", (Object)"/confirmed").put((Object)"data", (Object)"/data").put((Object)"decoded", (Object)"/object").put((Object)"rxInfo", (Object)"/rxInfo").put((Object)"frequency", (Object)"/txInfo/frequency").put((Object)"bandwidth", (Object)"/txInfo/modulation/lora/bandwidth").put((Object)"spreadingFactor", (Object)"/txInfo/modulation/lora/spreadingFactor").put((Object)"codeRate", (Object)"/txInfo/modulation/lora/codeRate").put((Object)"latitude", (Object)"/location/latitude").put((Object)"longitude", (Object)"/location/longitude").put((Object)"altitude", (Object)"/location/altitude").put((Object)"rssi", (Object)"").put((Object)"snr", (Object)"").build();

    @Override
    protected String getGatewayInfoPath() {
        return "/rxInfo";
    }

    @Override
    protected TbPair<byte[], ContentType> getPayload(JsonNode payloadJson) {
        if (payloadJson.has("object")) {
            JsonNode decoded = payloadJson.get("object");
            return TbPair.of((Object)JacksonUtil.writeValueAsBytes((Object)decoded), (Object)((Object)ContentType.JSON));
        }
        if (payloadJson.has("data")) {
            String data = payloadJson.get("data").textValue();
            return TbPair.of((Object)Base64.getDecoder().decode(data), (Object)((Object)ContentType.BINARY));
        }
        return TbPair.of((Object)EMPTY_BYTE_ARRAY, (Object)((Object)ContentType.BINARY));
    }

    @Override
    protected ImmutableMap<String, String> getKeysMapping() {
        return KEYS_MAPPING;
    }
}

