/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter.wrapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.wrapper.ConverterUnwrapper;
import org.thingsboard.integration.api.data.ContentType;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.server.common.data.util.TbPair;

public abstract class AbstractConverterUnwrapper
implements ConverterUnwrapper {
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    @Override
    public TbPair<byte[], UplinkMetaData<Object>> unwrap(byte[] payload, UplinkMetaData metadata) throws Exception {
        JsonNode payloadJson = JacksonUtil.fromBytes((byte[])payload);
        TreeMap<String, Object> kvMap = new TreeMap<String, Object>(metadata.getKvMap());
        this.getKeysMapping().forEach((name, path) -> {
            if (path.isEmpty()) {
                return;
            }
            JsonNode value = payloadJson.at(path);
            if (!value.isMissingNode()) {
                kvMap.put((String)name, JacksonUtil.convertValue((Object)value, Object.class));
            }
        });
        this.addGatewayAdditionalInfo(kvMap, payloadJson);
        this.postMapping(kvMap);
        kvMap.putAll(metadata.getKvMap());
        TbPair<byte[], ContentType> payloadPair = this.getPayload(payloadJson);
        UplinkMetaData<Object> mergedMetadata = new UplinkMetaData<Object>((ContentType)((Object)payloadPair.getSecond()), kvMap);
        return TbPair.of((Object)((byte[])payloadPair.getFirst()), mergedMetadata);
    }

    protected void addGatewayAdditionalInfo(Map<String, Object> kvMap, JsonNode payloadJson) {
        JsonNode rxMetadata;
        JsonNode rxMetadataArray = payloadJson.at(this.getGatewayInfoPath());
        if (!rxMetadataArray.isEmpty() && (rxMetadata = this.findByMaxRssi(rxMetadataArray)) != null) {
            kvMap.put("rssi", rxMetadata.get("rssi").asInt());
            kvMap.put("snr", rxMetadata.get("snr").asDouble());
        }
    }

    protected String getGatewayInfoPath() {
        return "";
    }

    protected JsonNode findByMaxRssi(JsonNode gwArray) {
        JsonNode result = null;
        int maxRssi = Integer.MIN_VALUE;
        for (JsonNode node : gwArray) {
            int rssi;
            JsonNode rssiNode = node.get("rssi");
            if (rssiNode == null || !rssiNode.isNumber() || (rssi = rssiNode.asInt()) <= maxRssi) continue;
            maxRssi = rssi;
            result = node;
        }
        return result;
    }

    protected abstract TbPair<byte[], ContentType> getPayload(JsonNode var1) throws Exception;

    protected void postMapping(Map<String, Object> kvMap) {
        long ts = 0L;
        if (kvMap.containsKey("time")) {
            long timeTs = this.parseDateToTimestamp(kvMap.get("time").toString());
            kvMap.put("timeTs", timeTs);
            ts = timeTs;
        }
        if (ts == 0L) {
            ts = System.currentTimeMillis();
        }
        kvMap.put("ts", ts);
    }

    protected long parseDateToTimestamp(String dateString) {
        try {
            return OffsetDateTime.parse(dateString).toInstant().toEpochMilli();
        }
        catch (DateTimeParseException e) {
            return 0L;
        }
    }

    protected abstract ImmutableMap<String, String> getKeysMapping();

    @Override
    public Set<String> getKeys() {
        return this.getKeysMapping().keySet();
    }
}

