/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.AbstractUplinkDataConverter;
import org.thingsboard.integration.api.converter.DedicatedConverterConfig;
import org.thingsboard.integration.api.converter.DedicatedConverterUtil;
import org.thingsboard.integration.api.converter.DedicatedUplinkData;
import org.thingsboard.integration.api.converter.ScriptUplinkEvaluator;
import org.thingsboard.integration.api.data.UplinkData;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.integration.api.util.LogSettingsComponent;
import org.thingsboard.script.api.ScriptInvokeService;
import org.thingsboard.script.api.js.JsInvokeService;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.script.ScriptLanguage;
import org.thingsboard.server.gen.transport.TransportProtos;

public class DedicatedScriptUplinkDataConverter
extends AbstractUplinkDataConverter {
    private ScriptUplinkEvaluator evaluator;
    private DedicatedConverterConfig config;

    public DedicatedScriptUplinkDataConverter(JsInvokeService jsInvokeService, TbelInvokeService tbelInvokeService, LogSettingsComponent logSettings) {
        super(jsInvokeService, tbelInvokeService, logSettings);
    }

    @Override
    public void init(Converter configuration) {
        super.init(configuration);
        this.config = (DedicatedConverterConfig)JacksonUtil.treeToValue((JsonNode)configuration.getConfiguration(), DedicatedConverterConfig.class);
        ScriptInvokeService scriptInvokeService = this.getScriptInvokeService(configuration);
        String decoderField = ScriptLanguage.JS.equals((Object)scriptInvokeService.getLanguage()) ? "decoder" : "tbelDecoder";
        String decoder = configuration.getConfiguration().get(decoderField).asText();
        this.evaluator = new ScriptUplinkEvaluator(configuration.getTenantId(), scriptInvokeService, (EntityId)configuration.getId(), decoder);
    }

    @Override
    public void update(Converter configuration) {
        this.destroy();
        this.init(configuration);
    }

    @Override
    public void destroy() {
        if (this.evaluator != null) {
            this.evaluator.destroy();
        }
    }

    @Override
    public ListenableFuture<String> doConvertUplink(byte[] data, UplinkMetaData metadata) throws Exception {
        return this.evaluator.execute(data, metadata);
    }

    @Override
    protected UplinkData parseUplinkData(JsonObject src, UplinkMetaData metadata) {
        DedicatedUplinkData uplinkData = DedicatedConverterUtil.parseUplinkData(this.config, src, metadata);
        boolean isAsset = uplinkData.getEntityType() == EntityType.ASSET;
        UplinkData.UplinkDataBuilder builder = UplinkData.builder();
        builder.isAsset(isAsset);
        String name = uplinkData.getName();
        String label = uplinkData.getLabel();
        String profile = uplinkData.getProfile();
        String customer = uplinkData.getCustomer();
        String group = uplinkData.getGroup();
        if (isAsset) {
            builder.assetName(name);
            builder.assetType(profile);
            if (label != null) {
                builder.assetLabel(label);
            }
        } else {
            builder.deviceName(name);
            builder.deviceType(profile);
            if (label != null) {
                builder.deviceLabel(label);
            }
        }
        if (customer != null) {
            builder.customerName(customer);
        }
        if (group != null) {
            builder.groupName(group);
        }
        Map currentOnValueTelemetryUpdate = this.currentUpdateOnlyTelemetryPerEntity.getOrDefault(name, new ConcurrentHashMap());
        Map currentOnValueAttributesUpdate = this.currentUpdateOnlyAttributesPerEntity.getOrDefault(name, new ConcurrentHashMap());
        TransportProtos.PostTelemetryMsg parsedTelemetry = this.parseTelemetry(uplinkData.getTelemetryJson());
        if (!this.updateOnlyKeys.isEmpty()) {
            parsedTelemetry = this.filterTelemetryOnKeyValueUpdateAndUpdateMap(parsedTelemetry, currentOnValueTelemetryUpdate);
        }
        builder.telemetry(parsedTelemetry);
        TransportProtos.PostAttributeMsg parsedAttributes = this.parseAttributesUpdate(uplinkData.getAttributesJson());
        if (!this.updateOnlyKeys.isEmpty()) {
            parsedAttributes = this.filterAttributeOnKeyValueUpdateAndUpdateMap(parsedAttributes, currentOnValueAttributesUpdate);
        }
        builder.attributesUpdate(parsedAttributes);
        if (!currentOnValueTelemetryUpdate.isEmpty()) {
            this.currentUpdateOnlyTelemetryPerEntity.put(name, currentOnValueTelemetryUpdate);
        }
        if (!currentOnValueAttributesUpdate.isEmpty()) {
            this.currentUpdateOnlyAttributesPerEntity.put(name, currentOnValueAttributesUpdate);
        }
        return builder.build();
    }
}

