/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.DedicatedConverterConfig;
import org.thingsboard.integration.api.converter.DedicatedUplinkData;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.util.CollectionsUtil;

public final class DedicatedConverterUtil {
    public static final String TELEMETRY = "telemetry";
    public static final String VALUES = "values";
    public static final String TS = "ts";
    public static final String ATTRIBUTES = "attributes";
    public static final String DEFAULT_PROFILE = "default";
    private static final Gson GSON = new Gson();

    private DedicatedConverterUtil() {
    }

    public static DedicatedUplinkData parseUplinkData(DedicatedConverterConfig config, JsonObject src, UplinkMetaData metadata) {
        JsonElement telemetry;
        HashMap<String, Object> kvMap = new HashMap<String, Object>(metadata.getKvMap());
        if (src.has(TELEMETRY)) {
            telemetry = src.get(TELEMETRY);
            if (telemetry.isJsonArray()) {
                JsonObject telemetryFromMetadata = DedicatedConverterUtil.addKvs(new JsonObject(), kvMap, config.getTelemetry());
                if (!telemetryFromMetadata.isEmpty()) {
                    telemetry.getAsJsonArray().add((JsonElement)telemetryFromMetadata);
                }
            } else if (telemetry.isJsonObject()) {
                JsonObject obj = telemetry.getAsJsonObject();
                if (obj.has(VALUES)) {
                    JsonObject values = obj.get(VALUES).getAsJsonObject();
                    DedicatedConverterUtil.addKvs(values, kvMap, config.getTelemetry());
                } else {
                    DedicatedConverterUtil.addKvs(obj, kvMap, config.getTelemetry());
                }
            }
        } else {
            telemetry = DedicatedConverterUtil.addKvs(new JsonObject(), kvMap, config.getTelemetry());
        }
        JsonObject attributes = src.has(ATTRIBUTES) ? src.get(ATTRIBUTES).getAsJsonObject() : new JsonObject();
        DedicatedConverterUtil.addKvs(attributes, kvMap, config.getAttributes());
        EntityType entityType = DedicatedConverterUtil.getProperty(src, "type", EntityType::valueOf, config::getType);
        String entityName = DedicatedConverterUtil.getProperty(src, "name", () -> DedicatedConverterUtil.processTemplate(config.getName(), kvMap));
        String profile = DedicatedConverterUtil.getProperty(src, "profile", () -> DedicatedConverterUtil.processTemplate(config.getProfile(), kvMap));
        if (profile == null) {
            profile = DEFAULT_PROFILE;
        }
        String label = DedicatedConverterUtil.getProperty(src, "label", () -> DedicatedConverterUtil.processTemplate(config.getLabel(), kvMap));
        String customer = DedicatedConverterUtil.getProperty(src, "customer", () -> DedicatedConverterUtil.processTemplate(config.getCustomer(), kvMap));
        String group = DedicatedConverterUtil.getProperty(src, "group", () -> DedicatedConverterUtil.processTemplate(config.getGroup(), kvMap));
        return DedicatedUplinkData.builder().entityType(entityType).name(entityName).profile(profile).label(label).customer(customer).group(group).telemetry(telemetry).attributes((JsonElement)attributes).build();
    }

    private static String getProperty(JsonObject src, String key, Supplier<String> defaultValue) {
        return DedicatedConverterUtil.getProperty(src, key, Function.identity(), defaultValue);
    }

    private static <T> T getProperty(JsonObject src, String key, Function<String, T> mapper, Supplier<T> defaultValue) {
        String value;
        JsonElement jsonValue = src.get(key);
        if (jsonValue != null && !jsonValue.isJsonNull() && StringUtils.isNotEmpty((String)(value = src.get(key).getAsString()))) {
            return mapper.apply(value);
        }
        return defaultValue.get();
    }

    private static JsonObject addKvs(JsonObject kvsObj, Map<String, Object> kvMap, Set<String> keys) {
        if (CollectionsUtil.isNotEmpty(keys) && !kvMap.isEmpty()) {
            kvMap.entrySet().stream().filter(e -> keys.contains(e.getKey()) && !kvsObj.has((String)e.getKey())).forEach(e -> kvsObj.add((String)e.getKey(), GSON.toJsonTree(e.getValue())));
        }
        return kvsObj;
    }

    private static String processTemplate(String template, Map<String, Object> data) {
        if (StringUtils.isNotEmpty((String)template)) {
            String result = template;
            for (Map.Entry<String, Object> kv : data.entrySet()) {
                result = DedicatedConverterUtil.processVar(result, kv.getKey(), kv.getValue());
            }
            return result;
        }
        return null;
    }

    private static String processVar(String pattern, String key, Object val) {
        String stringValue = val instanceof String ? (String)val : JacksonUtil.toString((Object)val);
        return pattern.replace(DedicatedConverterUtil.formatVarTemplate(key), stringValue);
    }

    private static String formatVarTemplate(String key) {
        return "$" + key;
    }
}

