/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import java.util.UUID;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.script.api.ScriptInvokeService;
import org.thingsboard.script.api.ScriptType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public abstract class AbstractScriptEvaluator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractScriptEvaluator.class);
    protected final ScriptInvokeService scriptInvokeService;
    private final ScriptType scriptType;
    private final String script;
    protected final TenantId tenantId;
    protected final EntityId entityId;
    protected volatile UUID scriptId;
    private volatile boolean isErrorScript = false;

    public AbstractScriptEvaluator(TenantId tenantId, ScriptInvokeService scriptInvokeService, EntityId entityId, ScriptType scriptType, String script) {
        this.scriptInvokeService = scriptInvokeService;
        this.scriptType = scriptType;
        this.script = script;
        this.tenantId = tenantId;
        this.entityId = entityId;
    }

    public void destroy() {
        if (this.scriptId != null) {
            this.scriptInvokeService.release(this.scriptId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateSuccessfulScriptLazyInit() {
        if (this.scriptId != null) {
            return;
        }
        if (this.isErrorScript) {
            throw new IllegalArgumentException("Can't compile uplink converter script ");
        }
        AbstractScriptEvaluator abstractScriptEvaluator = this;
        synchronized (abstractScriptEvaluator) {
            if (this.scriptId == null) {
                try {
                    this.scriptId = (UUID)this.scriptInvokeService.eval(this.tenantId, this.scriptType, this.script, this.getArgNames()).get();
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof TimeoutException)) {
                        this.isErrorScript = true;
                    }
                    throw new IllegalArgumentException("Can't compile script: " + e.getMessage(), e);
                }
            }
        }
    }

    protected abstract String[] getArgNames();
}

