/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.converter.TBDataConverter;
import org.thingsboard.integration.api.util.ConvertUtil;
import org.thingsboard.integration.api.util.ExceptionUtil;
import org.thingsboard.integration.api.util.LogSettingsComponent;
import org.thingsboard.script.api.ScriptInvokeService;
import org.thingsboard.script.api.js.JsInvokeService;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.event.ConverterDebugEvent;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.script.ScriptLanguage;

public abstract class AbstractDataConverter
implements TBDataConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataConverter.class);
    private final LogSettingsComponent logSettings;
    private final JsInvokeService jsInvokeService;
    private final TbelInvokeService tbelInvokeService;
    protected Converter configuration;

    public AbstractDataConverter(JsInvokeService jsInvokeService, TbelInvokeService tbelInvokeService, LogSettingsComponent logSettings) {
        this.jsInvokeService = jsInvokeService;
        this.tbelInvokeService = tbelInvokeService;
        this.logSettings = logSettings;
    }

    protected ScriptInvokeService getScriptInvokeService(Converter configuration) {
        JsInvokeService scriptInvokeService;
        ScriptLanguage scriptLang;
        JsonNode cfgJson = configuration.getConfiguration();
        ScriptLanguage scriptLanguage = scriptLang = cfgJson.has("scriptLang") ? ScriptLanguage.valueOf((String)cfgJson.get("scriptLang").asText()) : ScriptLanguage.JS;
        if (ScriptLanguage.JS.equals((Object)scriptLang)) {
            scriptInvokeService = this.jsInvokeService;
        } else {
            if (this.tbelInvokeService == null) {
                throw new RuntimeException("TBEL script engine is disabled!");
            }
            scriptInvokeService = this.tbelInvokeService;
        }
        return scriptInvokeService;
    }

    @Override
    public void init(Converter configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getName() {
        return this.configuration != null ? this.configuration.getName() : null;
    }

    protected String toString(Exception e) {
        return ExceptionUtil.toString(e, (EntityId)this.configuration.getId(), this.logSettings.isExceptionStackTraceEnabled());
    }

    protected void persistDebug(ConverterContext context, String type, String inMessageType, byte[] inMessage, String outMessageType, byte[] outMessage, String metadata, Exception exception) {
        ConverterDebugEvent.ConverterDebugEventBuilder event = ConverterDebugEvent.builder().tenantId(this.configuration.getTenantId()).entityId(this.configuration.getId().getId()).serviceId(context.getServiceId()).eventType(type).inMsgType(inMessageType).inMsg(ConvertUtil.toDebugMessage(inMessageType, inMessage)).outMsgType(outMessageType).outMsg(ConvertUtil.toDebugMessage(outMessageType, outMessage)).metadata(metadata);
        if (exception != null) {
            event.error(this.toString(exception));
        }
        context.saveEvent((Event)event.build(), new DebugEventCallback());
    }

    private static class DebugEventCallback
    implements IntegrationCallback<Void> {
        private DebugEventCallback() {
        }

        @Override
        public void onSuccess(Void msg) {
            if (log.isDebugEnabled()) {
                log.debug("Event has been saved successfully!");
            }
        }

        @Override
        public void onError(Throwable e) {
            log.error("Failed to save the debug event!", e);
        }
    }
}

