/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api;

import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.thingsboard.integration.api.IntegrationContext;

public class IntegrationStatistics {
    private final IntegrationContext ctx;
    private final AtomicLong messagesProcessed;
    private final AtomicLong errorsOccurred;

    public IntegrationStatistics(IntegrationContext ctx) {
        this.ctx = ctx;
        this.messagesProcessed = new AtomicLong(0L);
        this.errorsOccurred = new AtomicLong(0L);
    }

    public void incMessagesProcessed() {
        this.messagesProcessed.incrementAndGet();
        this.ctx.onUplinkMessageProcessed(true);
    }

    public void incErrorsOccurred() {
        this.errorsOccurred.incrementAndGet();
        this.ctx.onUplinkMessageProcessed(false);
    }

    public long getMessagesProcessed() {
        return this.messagesProcessed.get();
    }

    public long getErrorsOccurred() {
        return this.errorsOccurred.get();
    }

    public boolean isEmpty() {
        return this.getMessagesProcessed() == 0L && this.getErrorsOccurred() == 0L;
    }

    @Generated
    public String toString() {
        return "IntegrationStatistics(ctx=" + String.valueOf(this.ctx) + ", messagesProcessed=" + this.getMessagesProcessed() + ", errorsOccurred=" + this.getErrorsOccurred() + ")";
    }
}

