/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DebugModeUtil;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.IntegrationContext;
import org.thingsboard.integration.api.IntegrationRateLimitService;
import org.thingsboard.integration.api.IntegrationStatistics;
import org.thingsboard.integration.api.TbIntegrationInitParams;
import org.thingsboard.integration.api.ThingsboardPlatformIntegration;
import org.thingsboard.integration.api.converter.TBDownlinkDataConverter;
import org.thingsboard.integration.api.converter.TBUplinkDataConverter;
import org.thingsboard.integration.api.data.ContentType;
import org.thingsboard.integration.api.data.DownlinkData;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.integration.api.data.UplinkData;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.integration.api.util.ExceptionUtil;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.event.IntegrationDebugEvent;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.tools.TbRateLimitsException;
import org.thingsboard.server.gen.integration.AssetUplinkDataProto;
import org.thingsboard.server.gen.integration.DeviceUplinkDataProto;
import org.thingsboard.server.gen.integration.EntityViewDataProto;

public abstract class AbstractIntegration<T>
implements ThingsboardPlatformIntegration<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractIntegration.class);
    protected Integration configuration;
    protected IntegrationContext context;
    protected TBUplinkDataConverter uplinkConverter;
    protected TBDownlinkDataConverter downlinkConverter;
    protected UplinkMetaData<String> metadataTemplate;
    protected IntegrationStatistics integrationStatistics;

    @Override
    public void init(TbIntegrationInitParams params) throws Exception {
        this.configuration = params.getConfiguration();
        this.context = params.getContext();
        this.uplinkConverter = params.getUplinkConverter();
        this.downlinkConverter = params.getDownlinkConverter();
        HashMap<String, String> mdMap = new HashMap<String, String>();
        mdMap.put("integrationName", this.configuration.getName());
        JsonNode metadata = this.configuration.getConfiguration().get("metadata");
        Iterator it = metadata.fields();
        while (it.hasNext()) {
            Map.Entry md = (Map.Entry)it.next();
            mdMap.put((String)md.getKey(), ((JsonNode)md.getValue()).asText());
        }
        this.metadataTemplate = new UplinkMetaData(this.getDefaultUplinkContentType(), mdMap);
        if (this.integrationStatistics == null) {
            this.integrationStatistics = new IntegrationStatistics(this.context);
        }
    }

    public void setConfiguration(Integration configuration) {
        this.configuration = configuration;
    }

    protected ContentType getDefaultUplinkContentType() {
        return ContentType.JSON;
    }

    @Override
    public void update(TbIntegrationInitParams params) throws Exception {
        this.destroy();
        this.init(params);
    }

    @Override
    public Integration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void validateConfiguration(Integration configuration, boolean allowLocalNetworkHosts) throws ThingsboardException {
        if (configuration == null || configuration.getConfiguration() == null) {
            throw new IllegalArgumentException("Integration configuration is empty!");
        }
        if (!configuration.isRemote().booleanValue()) {
            this.doValidateConfiguration(configuration.getConfiguration(), allowLocalNetworkHosts);
        }
    }

    @Override
    public void checkConnection(Integration integration, IntegrationContext ctx) throws ThingsboardException {
        if (integration == null || integration.getConfiguration() == null) {
            throw new IllegalArgumentException("Integration configuration is empty!");
        }
        if (!integration.isRemote().booleanValue()) {
            try {
                this.doCheckConnection(integration, ctx);
            }
            finally {
                this.destroy();
            }
        }
    }

    @Override
    public void onDownlinkMsg(IntegrationDownlinkMsg msg) {
    }

    @Override
    public IntegrationStatistics popStatistics() {
        IntegrationStatistics statistics = this.integrationStatistics;
        this.integrationStatistics = new IntegrationStatistics(this.context);
        return statistics;
    }

    @Override
    public ListenableFuture<Void> processAsync(T msg) {
        throw new RuntimeException("Process async not implemented");
    }

    protected <T> T getClientConfiguration(Integration configuration, Class<T> clazz) {
        JsonNode clientConfiguration = configuration.getConfiguration().get("clientConfiguration");
        return this.getClientConfiguration(clientConfiguration, clazz);
    }

    protected <T> T getClientConfiguration(JsonNode clientConfiguration, Class<T> clazz) {
        if (clientConfiguration == null) {
            throw new IllegalArgumentException("clientConfiguration field is missing!");
        }
        return (T)JacksonUtil.convertValue((Object)clientConfiguration, clazz);
    }

    protected void doValidateConfiguration(JsonNode configuration, boolean allowLocalNetworkHosts) throws ThingsboardException {
    }

    protected void doCheckConnection(Integration integration, IntegrationContext ctx) throws ThingsboardException {
    }

    protected void processUplinkData(IntegrationContext context, UplinkData data) {
        if (data.isAsset()) {
            this.processAssetUplinkData(context, data);
        } else {
            this.processDeviceUplinkData(context, data);
        }
    }

    private void processDeviceUplinkData(IntegrationContext context, UplinkData data) {
        String entityName = data.getDeviceName();
        TenantId tenantId = this.configuration.getTenantId();
        context.getRateLimitService().ifPresent(rls -> rls.checkLimitPerDevice(tenantId, entityName, data::toString));
        DeviceUplinkDataProto.Builder builder = DeviceUplinkDataProto.newBuilder().setDeviceName(entityName).setDeviceType(data.getDeviceType());
        if (StringUtils.isNotEmpty((String)data.getDeviceLabel())) {
            builder.setDeviceLabel(data.getDeviceLabel());
        }
        if (StringUtils.isNotEmpty((String)data.getCustomerName())) {
            builder.setCustomerName(data.getCustomerName());
        }
        if (StringUtils.isNotEmpty((String)data.getGroupName())) {
            builder.setGroupName(data.getGroupName());
        }
        if (data.getTelemetry() != null) {
            builder.setPostTelemetryMsg(data.getTelemetry());
        }
        if (data.getAttributesUpdate() != null) {
            builder.setPostAttributesMsg(data.getAttributesUpdate());
        }
        context.processUplinkData(builder.build(), null);
    }

    private void processAssetUplinkData(IntegrationContext context, UplinkData data) {
        String entityName = data.getAssetName();
        TenantId tenantId = this.configuration.getTenantId();
        context.getRateLimitService().ifPresent(rls -> rls.checkLimitPerAsset(tenantId, entityName, data::toString));
        AssetUplinkDataProto.Builder builder = AssetUplinkDataProto.newBuilder().setAssetName(entityName).setAssetType(data.getAssetType());
        if (StringUtils.isNotEmpty((String)data.getAssetLabel())) {
            builder.setAssetLabel(data.getAssetLabel());
        }
        if (StringUtils.isNotEmpty((String)data.getCustomerName())) {
            builder.setCustomerName(data.getCustomerName());
        }
        if (StringUtils.isNotEmpty((String)data.getGroupName())) {
            builder.setGroupName(data.getGroupName());
        }
        if (data.getTelemetry() != null) {
            builder.setPostTelemetryMsg(data.getTelemetry());
        }
        if (data.getTelemetry() != null) {
            builder.setPostTelemetryMsg(data.getTelemetry());
        }
        if (data.getAttributesUpdate() != null) {
            builder.setPostAttributesMsg(data.getAttributesUpdate());
        }
        context.processUplinkData(builder.build(), null);
    }

    protected void createEntityView(IntegrationContext context, UplinkData data, String viewName, String viewType, List<String> telemetryKeys) {
        context.createEntityView(EntityViewDataProto.newBuilder().setViewName(viewName).setViewType(viewType).setDeviceName(data.getDeviceName()).setDeviceType(data.getDeviceType()).addAllTelemetryKeys(telemetryKeys).build(), null);
    }

    protected static boolean isLocalNetworkHost(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            if (address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress()) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unable to resolve provided hostname: " + host);
        }
        return false;
    }

    protected void persistDebug(IntegrationContext context, String type, ContentType messageType, Supplier<String> message, String status, Throwable exception) {
        this.persistDebug(context, type, messageType.name(), message, null, status, exception);
    }

    protected void persistDebug(IntegrationContext context, String type, ContentType messageType, String message, String status, Throwable exception) {
        this.persistDebug(context, type, messageType.name(), null, message, status, exception);
    }

    protected void persistDebug(IntegrationContext context, String type, String messageType, Supplier<String> msgSupplier, String message, String status, Throwable exception) {
        try {
            this.doPersistDebug(context, type, messageType, msgSupplier != null ? msgSupplier.get() : message, status, exception);
        }
        catch (Exception e) {
            log.warn("[{}] Failed to persist debug message", (Object)this.configuration, (Object)e);
        }
    }

    private void doPersistDebug(IntegrationContext context, String type, String messageType, String message, String status, Throwable exception) {
        if (!DebugModeUtil.isDebugAvailable((HasDebugSettings)this.configuration, (String)status)) {
            return;
        }
        IntegrationId integrationId = this.configuration.getId();
        if (exception instanceof TbRateLimitsException) {
            EntityType limitedEntity = ((TbRateLimitsException)exception).getEntityType();
            if (context.getRateLimitService().get().alreadyProcessed((EntityId)integrationId, limitedEntity)) {
                log.trace("[{}] [{}] [{}] Rate limited debug event already sent.", new Object[]{this.configuration.getTenantId(), integrationId, limitedEntity});
                return;
            }
        } else if (!context.getRateLimitService().map(s -> s.checkLimit(this.configuration.getTenantId(), integrationId, false)).orElse(true).booleanValue()) {
            if (context.getRateLimitService().get().alreadyProcessed((EntityId)integrationId, EntityType.INTEGRATION)) {
                log.trace("[{}] [{}] [{}] Rate limited debug event already sent.", new Object[]{this.configuration.getTenantId(), integrationId, EntityType.INTEGRATION});
                return;
            }
            exception = new TbRateLimitsException(EntityType.INTEGRATION, "Integration debug rate limits reached!");
            status = "ERROR";
        }
        IntegrationDebugEvent.IntegrationDebugEventBuilder event = IntegrationDebugEvent.builder().tenantId(this.configuration.getTenantId()).entityId(this.configuration.getId().getId()).serviceId(context.getServiceId()).eventType(type).messageType(messageType).message(message).status(status);
        if (exception != null) {
            event.error(this.toString(exception));
        }
        context.saveEvent(event.build(), new DebugEventCallback());
    }

    protected String toString(Throwable e) {
        return ExceptionUtil.toString(e, (EntityId)this.configuration.getId(), this.context.isExceptionStackTraceEnabled());
    }

    protected ListenableFuture<List<UplinkData>> convertToUplinkDataListAsync(IntegrationContext context, byte[] data, UplinkMetaData md) {
        try {
            Optional<IntegrationRateLimitService> rateLimitService = context.getRateLimitService();
            rateLimitService.ifPresent(s -> s.checkLimit(this.configuration.getTenantId(), () -> new String(data)));
            return this.uplinkConverter.convertUplink(context.getUplinkConverterContext(), data, md, context.getCallBackExecutorService());
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Failed to apply uplink data converter function for data: {} and metadata: {}", new Object[]{this.configuration.getId(), this.configuration.getName(), Base64.getEncoder().encodeToString(data), md});
            }
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    protected List<UplinkData> convertToUplinkDataList(IntegrationContext context, byte[] data, UplinkMetaData<String> md) throws Exception {
        try {
            return (List)this.convertToUplinkDataListAsync(context, data, md).get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TbRateLimitsException) {
                TbRateLimitsException rateLimitsException = (TbRateLimitsException)throwable;
                throw rateLimitsException;
            }
            throw e;
        }
    }

    protected void reportDownlinkOk(IntegrationContext context, DownlinkData data) {
        context.onDownlinkMessageProcessed(true);
        this.integrationStatistics.incMessagesProcessed();
        String status = this.downlinkConverter != null ? "OK" : "FAILURE";
        Supplier<String> msgSupplier = () -> {
            ObjectNode json = JacksonUtil.newObjectNode();
            if (data.getMetadata() != null && !data.getMetadata().isEmpty()) {
                json.set("metadata", JacksonUtil.valueToTree(data.getMetadata()));
            }
            json.set("payload", this.getDownlinkPayloadJson(data));
            return JacksonUtil.toString((Object)json);
        };
        this.persistDebug(context, "Downlink", ContentType.JSON, msgSupplier, status, null);
    }

    protected void reportDownlinkError(IntegrationContext context, TbMsg msg, String status, Exception exception) {
        if (!status.equals("OK")) {
            context.onDownlinkMessageProcessed(false);
            this.integrationStatistics.incErrorsOccurred();
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Failed to apply downlink data converter function for data: {} and metadata: {}", new Object[]{this.configuration.getId(), this.configuration.getName(), msg.getData(), msg.getMetaData()});
            }
            this.persistDebug(context, "Downlink", ContentType.JSON, () -> JacksonUtil.toString((Object)msg), status, (Throwable)exception);
        }
    }

    protected JsonNode getDownlinkPayloadJson(DownlinkData data) {
        String contentType = data.getContentType();
        if ("JSON".equals(contentType)) {
            return JacksonUtil.fromBytes((byte[])data.getData());
        }
        if ("TEXT".equals(contentType)) {
            return new TextNode(new String(data.getData(), StandardCharsets.UTF_8));
        }
        return new TextNode(Base64.getEncoder().encodeToString(data.getData()));
    }

    protected <T> void logDownlink(IntegrationContext context, String updateType, T msg) {
        String status = this.downlinkConverter != null ? "OK" : "FAILURE";
        this.persistDebug(context, updateType, ContentType.JSON, () -> JacksonUtil.toString((Object)msg), status, null);
    }

    private static class DebugEventCallback
    implements IntegrationCallback<Void> {
        private DebugEventCallback() {
        }

        @Override
        public void onSuccess(Void msg) {
            if (log.isDebugEnabled()) {
                log.debug("Event has been saved successfully!");
            }
        }

        @Override
        public void onError(Throwable e) {
            log.error("Failed to save the debug event!", e);
        }
    }
}

