/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.util;

import com.google.gson.JsonParseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.msg.tools.TbRateLimitsException;

public class ExceptionUtil {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtil.class);

    public static <T extends Exception> T lookupException(Throwable source, Class<T> clazz) {
        Exception e = ExceptionUtil.lookupExceptionInCause(source, clazz);
        if (e != null) {
            return (T)e;
        }
        return null;
    }

    public static Exception lookupExceptionInCause(Throwable source, Class<? extends Exception> ... clazzes) {
        if (source == null) {
            return null;
        }
        for (Class<? extends Exception> clazz : clazzes) {
            if (!clazz.isAssignableFrom(source.getClass())) continue;
            return (Exception)source;
        }
        return ExceptionUtil.lookupExceptionInCause(source.getCause(), clazzes);
    }

    public static String toString(Throwable e, EntityId componentId, boolean stackTraceEnabled) {
        Exception exception = ExceptionUtil.lookupExceptionInCause(e, ScriptException.class, JsonParseException.class, TbRateLimitsException.class);
        if (exception != null && StringUtils.isNotEmpty((String)exception.getMessage())) {
            return exception.getMessage();
        }
        if (stackTraceEnabled) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
        log.debug("[{}] Unknown error during message processing", (Object)componentId, (Object)e);
        return "Please contact system administrator";
    }
}

