/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Base64;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.AbstractScriptEvaluator;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.script.api.ScriptInvokeService;
import org.thingsboard.script.api.ScriptType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.script.ScriptLanguage;

public class ScriptUplinkEvaluator
extends AbstractScriptEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ScriptUplinkEvaluator.class);

    public ScriptUplinkEvaluator(TenantId tenantId, ScriptInvokeService invokeService, EntityId entityId, String script) {
        super(tenantId, invokeService, entityId, ScriptType.UPLINK_CONVERTER_SCRIPT, script);
    }

    public ListenableFuture<String> execute(byte[] data, UplinkMetaData metadata) throws Exception {
        this.validateSuccessfulScriptLazyInit();
        Object[] inArgs = ScriptUplinkEvaluator.prepareArgs(this.scriptInvokeService.getLanguage(), data, metadata);
        return Futures.transform((ListenableFuture)this.scriptInvokeService.invokeScript(this.tenantId, null, this.scriptId, new Object[]{inArgs[0], inArgs[1]}), eval -> {
            if (eval instanceof String) {
                return eval.toString();
            }
            return JacksonUtil.toString((Object)eval);
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static Object[] prepareArgs(ScriptLanguage scriptLang, byte[] data, UplinkMetaData metadata) {
        if (ScriptLanguage.JS.equals((Object)scriptLang)) {
            try {
                Object[] args = new String[]{Base64.getEncoder().encodeToString(data), JacksonUtil.toString(metadata.getKvMap())};
                return args;
            }
            catch (Throwable th) {
                throw new IllegalArgumentException("Cannot bind js args", th);
            }
        }
        Object[] args = new Object[]{data, new HashMap<String, String>(metadata.getKvMap())};
        return args;
    }

    @Override
    protected String[] getArgNames() {
        return new String[]{"payload", "metadata"};
    }
}

