/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.AbstractScriptEvaluator;
import org.thingsboard.integration.api.data.IntegrationMetaData;
import org.thingsboard.script.api.ScriptInvokeService;
import org.thingsboard.script.api.ScriptType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.script.ScriptLanguage;
import org.thingsboard.server.common.msg.TbMsg;

public class ScriptDownlinkEvaluator
extends AbstractScriptEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ScriptDownlinkEvaluator.class);

    public ScriptDownlinkEvaluator(TenantId tenantId, ScriptInvokeService scriptInvokeService, EntityId entityId, String script) {
        super(tenantId, scriptInvokeService, entityId, ScriptType.DOWNLINK_CONVERTER_SCRIPT, script);
    }

    public JsonNode execute(TbMsg msg, IntegrationMetaData metadata) throws ScriptException {
        try {
            this.validateSuccessfulScriptLazyInit();
            Object[] inArgs = ScriptDownlinkEvaluator.prepareArgs(this.scriptInvokeService.getLanguage(), msg, metadata);
            Object eval = this.scriptInvokeService.invokeScript(this.tenantId, msg.getCustomerId(), this.scriptId, new Object[]{inArgs[0], inArgs[1], inArgs[2], inArgs[3]}).get();
            if (eval instanceof String) {
                return JacksonUtil.toJsonNode((String)eval.toString());
            }
            return JacksonUtil.valueToTree((Object)eval);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ScriptException) {
                throw (ScriptException)e.getCause();
            }
            throw new ScriptException("Failed to execute js script: " + e.getMessage());
        }
        catch (Exception e) {
            throw new ScriptException("Failed to execute js script: " + e.getMessage());
        }
    }

    private static Object[] prepareArgs(ScriptLanguage scriptLang, TbMsg msg, IntegrationMetaData metadata) {
        if (ScriptLanguage.JS.equals((Object)scriptLang)) {
            try {
                Object[] args = new String[]{msg.getData() != null ? msg.getData() : "", JacksonUtil.toString((Object)msg.getMetaData().getData()), msg.getType(), JacksonUtil.toString(metadata.getKvMap())};
                return args;
            }
            catch (Throwable th) {
                throw new IllegalArgumentException("Cannot bind js args", th);
            }
        }
        Object[] args = new Object[]{msg.getData() != null ? JacksonUtil.fromString((String)msg.getData(), Map.class) : new HashMap(), new HashMap(msg.getMetaData().getData()), msg.getType(), new HashMap<String, String>(metadata.getKvMap())};
        return args;
    }

    @Override
    protected String[] getArgNames() {
        return new String[]{"msg", "metadata", "msgType", "integrationMetadata"};
    }
}

