/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.AbstractDataConverter;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.converter.TBUplinkDataConverter;
import org.thingsboard.integration.api.data.UplinkContentType;
import org.thingsboard.integration.api.data.UplinkData;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.script.api.js.JsInvokeService;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.msg.tools.TbRateLimitsException;
import org.thingsboard.server.gen.transport.TransportProtos;

public abstract class AbstractUplinkDataConverter
extends AbstractDataConverter
implements TBUplinkDataConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractUplinkDataConverter.class);
    private static final String DEFAULT_DEVICE_TYPE = "default";
    private static final int MAX_ALLOWED_STRING_LENGTH = 32;
    private final Set<String> updateOnlyKeys = new HashSet<String>();
    private final Map<String, Map<String, String>> currentUpdateOnlyTelemetryPerEntity = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> currentUpdateOnlyAttributesPerEntity = new ConcurrentHashMap<String, Map<String, String>>();

    public AbstractUplinkDataConverter(JsInvokeService jsInvokeService, TbelInvokeService tbelInvokeService) {
        super(jsInvokeService, tbelInvokeService);
    }

    @Override
    public void init(Converter configuration) {
        this.configuration = configuration;
        JsonNode configurationNode = configuration.getConfiguration();
        this.updateOnlyKeys.clear();
        JsonNode updateOnlyKeysNode = configurationNode.get("updateOnlyKeys");
        if (updateOnlyKeysNode != null && updateOnlyKeysNode.isArray()) {
            updateOnlyKeysNode.elements().forEachRemaining(key -> this.updateOnlyKeys.add(this.getAllowedValue(key.asText())));
        }
        this.currentUpdateOnlyTelemetryPerEntity.values().forEach(entityKeys -> entityKeys.keySet().retainAll(this.updateOnlyKeys));
        this.currentUpdateOnlyAttributesPerEntity.values().forEach(entityKeys -> entityKeys.keySet().retainAll(this.updateOnlyKeys));
    }

    @Override
    public ListenableFuture<List<UplinkData>> convertUplink(ConverterContext context, byte[] data, UplinkMetaData metadata, ExecutorService callBackExecutorService) throws Exception {
        long startTime = System.currentTimeMillis();
        ListenableFuture<String> convertFuture = this.doConvertUplink(data, metadata);
        ListenableFuture result = Futures.transform(convertFuture, rawResult -> {
            if (log.isTraceEnabled()) {
                log.trace("[{}][{}] Uplink conversion took {} ms.", new Object[]{this.configuration.getId(), this.configuration.getName(), System.currentTimeMillis() - startTime});
            }
            JsonElement element = new JsonParser().parse(rawResult);
            ArrayList<UplinkData> resultList = new ArrayList<UplinkData>();
            if (element.isJsonArray()) {
                for (JsonElement uplinkJson : element.getAsJsonArray()) {
                    resultList.add(this.parseUplinkData(uplinkJson.getAsJsonObject()));
                }
            } else if (element.isJsonObject()) {
                resultList.add(this.parseUplinkData(element.getAsJsonObject()));
            }
            if (this.configuration.isDebugMode()) {
                if (context.getRateLimitService().map(s -> s.checkLimit(this.configuration.getTenantId(), this.configuration.getId(), false)).orElse(true).booleanValue()) {
                    this.persistUplinkDebug(context, metadata.getContentType(), data, (String)rawResult, metadata);
                } else if (context.getRateLimitService().get().alreadyProcessed((EntityId)this.configuration.getId(), EntityType.CONVERTER)) {
                    log.trace("[{}] [{}] [{}] Rate limited debug event already sent.", new Object[]{this.configuration.getTenantId(), this.configuration.getId(), EntityType.CONVERTER});
                } else {
                    TbRateLimitsException exception = new TbRateLimitsException(EntityType.CONVERTER, "Converter debug rate limits reached!");
                    this.persistUplinkDebug(context, metadata.getContentType(), data, metadata, (Exception)exception);
                }
            }
            return resultList;
        }, (Executor)callBackExecutorService);
        DonAsynchron.withCallback((ListenableFuture)result, r -> {}, t -> {
            if (t instanceof Exception) {
                if (this.configuration.isDebugMode()) {
                    this.persistUplinkDebug(context, metadata.getContentType(), data, metadata, (Exception)t);
                }
            } else {
                log.warn("[{}][{}] Unhandled exception: ", new Object[]{this.configuration.getId(), this.configuration.getName(), t});
            }
        }, (Executor)callBackExecutorService);
        return result;
    }

    protected abstract ListenableFuture<String> doConvertUplink(byte[] var1, UplinkMetaData var2) throws Exception;

    protected UplinkData parseUplinkData(JsonObject src) {
        String entityName;
        boolean isAsset = this.getIsAssetAndVerify(src);
        UplinkData.UplinkDataBuilder builder = UplinkData.builder();
        builder.isAsset(isAsset);
        if (isAsset) {
            entityName = src.get("assetName").getAsString();
            builder.assetName(entityName);
            builder.assetType(src.get("assetType").getAsString());
            if (src.has("assetLabel")) {
                builder.assetLabel(src.get("assetLabel").getAsString());
            }
        } else {
            entityName = src.get("deviceName").getAsString();
            builder.deviceName(entityName);
            if (src.has("deviceType")) {
                builder.deviceType(src.get("deviceType").getAsString());
            } else {
                builder.deviceType(DEFAULT_DEVICE_TYPE);
            }
            if (src.has("deviceLabel")) {
                builder.deviceLabel(src.get("deviceLabel").getAsString());
            }
        }
        if (src.has("customerName")) {
            builder.customerName(src.get("customerName").getAsString());
        }
        if (src.has("groupName")) {
            builder.groupName(src.get("groupName").getAsString());
        }
        Map currentOnValueTelemetryUpdate = this.currentUpdateOnlyTelemetryPerEntity.getOrDefault(entityName, new ConcurrentHashMap());
        Map currentOnValueAttributesUpdate = this.currentUpdateOnlyAttributesPerEntity.getOrDefault(entityName, new ConcurrentHashMap());
        if (src.has("telemetry")) {
            TransportProtos.PostTelemetryMsg parsedTelemetry = this.parseTelemetry(src.get("telemetry"));
            if (!this.updateOnlyKeys.isEmpty()) {
                parsedTelemetry = this.filterTelemetryOnKeyValueUpdateAndUpdateMap(parsedTelemetry, currentOnValueTelemetryUpdate);
            }
            builder.telemetry(parsedTelemetry);
        }
        if (src.has("attributes")) {
            TransportProtos.PostAttributeMsg attributes = this.parseAttributesUpdate(src.get("attributes"));
            if (!this.updateOnlyKeys.isEmpty()) {
                attributes = this.filterAttributeOnKeyValueUpdateAndUpdateMap(attributes, currentOnValueAttributesUpdate);
            }
            builder.attributesUpdate(attributes);
        }
        if (!currentOnValueTelemetryUpdate.isEmpty()) {
            this.currentUpdateOnlyTelemetryPerEntity.put(entityName, currentOnValueTelemetryUpdate);
        }
        if (!currentOnValueAttributesUpdate.isEmpty()) {
            this.currentUpdateOnlyAttributesPerEntity.put(entityName, currentOnValueAttributesUpdate);
        }
        return builder.build();
    }

    private TransportProtos.PostTelemetryMsg filterTelemetryOnKeyValueUpdateAndUpdateMap(TransportProtos.PostTelemetryMsg telemetry, Map<String, String> currentEntityKeyValues) {
        TransportProtos.PostTelemetryMsg.Builder filteredTelemetryBuilder = TransportProtos.PostTelemetryMsg.newBuilder();
        for (TransportProtos.TsKvListProto tsKvList : telemetry.getTsKvListList()) {
            TransportProtos.TsKvListProto.Builder filteredTsKvListBuilder = TransportProtos.TsKvListProto.newBuilder().setTs(tsKvList.getTs());
            List<TransportProtos.KeyValueProto> filtered = this.filterKeyValueAndUpdateMap(tsKvList.getKvList(), currentEntityKeyValues);
            filteredTsKvListBuilder.addAllKv(filtered);
            if (filteredTsKvListBuilder.getKvList().isEmpty()) continue;
            filteredTelemetryBuilder.addTsKvList(filteredTsKvListBuilder.build());
        }
        return !currentEntityKeyValues.isEmpty() ? filteredTelemetryBuilder.build() : telemetry;
    }

    private TransportProtos.PostAttributeMsg filterAttributeOnKeyValueUpdateAndUpdateMap(TransportProtos.PostAttributeMsg attributes, Map<String, String> currentEntityKeyValues) {
        TransportProtos.PostAttributeMsg.Builder filteredAttributesBuilder = TransportProtos.PostAttributeMsg.newBuilder();
        List<TransportProtos.KeyValueProto> filtered = this.filterKeyValueAndUpdateMap(attributes.getKvList(), currentEntityKeyValues);
        filteredAttributesBuilder.addAllKv(filtered);
        return !currentEntityKeyValues.isEmpty() ? filteredAttributesBuilder.build() : attributes;
    }

    List<TransportProtos.KeyValueProto> filterKeyValueAndUpdateMap(List<TransportProtos.KeyValueProto> kvList, Map<String, String> currentEntityKeyValues) {
        ArrayList<TransportProtos.KeyValueProto> filtered = new ArrayList<TransportProtos.KeyValueProto>();
        for (TransportProtos.KeyValueProto keyValue : kvList) {
            String key = this.getAllowedValue(keyValue.getKey());
            boolean isOnValueUpdate = this.updateOnlyKeys.contains(key);
            if (isOnValueUpdate) {
                String value = this.getValueAsAllowedString(keyValue);
                boolean shouldAddToResult = currentEntityKeyValues.isEmpty() || !currentEntityKeyValues.containsKey(key) || !currentEntityKeyValues.get(key).equals(value);
                if (!shouldAddToResult) continue;
                filtered.add(keyValue);
                currentEntityKeyValues.put(key, value);
                continue;
            }
            filtered.add(keyValue);
        }
        return filtered;
    }

    private String getValueAsAllowedString(TransportProtos.KeyValueProto keyValueProto) {
        switch (keyValueProto.getType()) {
            case STRING_V: {
                return this.getAllowedValue(keyValueProto.getStringV());
            }
            case JSON_V: {
                return this.getAllowedValue(keyValueProto.getJsonV());
            }
            case DOUBLE_V: {
                return this.getAllowedValue(String.valueOf(keyValueProto.getDoubleV()));
            }
            case LONG_V: {
                return this.getAllowedValue(String.valueOf(keyValueProto.getLongV()));
            }
            case BOOLEAN_V: {
                return this.getAllowedValue(String.valueOf(keyValueProto.getBoolV()));
            }
        }
        return null;
    }

    private boolean getIsAssetAndVerify(JsonObject src) {
        boolean isAsset;
        boolean isDeviceNamePresent = src.has("deviceName");
        boolean isAssetNamePresent = src.has("assetName");
        boolean isAssetTypePresent = src.has("assetType");
        if (!isDeviceNamePresent && !isAssetNamePresent) {
            throw new JsonParseException("Either 'deviceName' or 'assetName' should be present in the converter output!");
        }
        if (isDeviceNamePresent && isAssetNamePresent) {
            throw new JsonParseException("Both 'deviceName' and 'assetName' can't be present in the converter output!");
        }
        if (isDeviceNamePresent) {
            isAsset = false;
        } else {
            if (!isAssetTypePresent) {
                throw new JsonParseException("Asset type is not set!");
            }
            isAsset = true;
        }
        return isAsset;
    }

    private TransportProtos.PostTelemetryMsg parseTelemetry(JsonElement src) {
        return JsonConverter.convertToTelemetryProto((JsonElement)src);
    }

    private TransportProtos.PostAttributeMsg parseAttributesUpdate(JsonElement src) {
        return JsonConverter.convertToAttributesProto((JsonElement)src);
    }

    private void persistUplinkDebug(ConverterContext context, UplinkContentType inMessageType, byte[] inMessage, String outMessage, UplinkMetaData metadata) {
        try {
            this.persistDebug(context, this.getTypeUplink(inMessage), inMessageType.name(), inMessage, "JSON", outMessage.getBytes(StandardCharsets.UTF_8), this.metadataToJson(metadata), null);
        }
        catch (JsonProcessingException e) {
            log.warn("Failed to persist uplink debug message");
        }
    }

    private void persistUplinkDebug(ConverterContext context, UplinkContentType inMessageType, byte[] inMessage, UplinkMetaData metadata, Exception e) {
        try {
            this.persistDebug(context, "Uplink", inMessageType.name(), inMessage, null, null, this.metadataToJson(metadata), e);
        }
        catch (JsonProcessingException ex) {
            log.warn("Failed to persist uplink debug message", (Throwable)ex);
        }
    }

    private String metadataToJson(UplinkMetaData metaData) throws JsonProcessingException {
        return JacksonUtil.toString(metaData.getKvMap());
    }

    private String getTypeUplink(byte[] inMessage) throws JsonProcessingException {
        return inMessage != null && inMessage.length > 23 && Arrays.equals(Arrays.copyOfRange(inMessage, 1, 23), JacksonUtil.writeValueAsBytes((Object)"DevEUI_downlink_Sent")) ? "Downlink_Sent" : "Uplink";
    }

    private String getAllowedValue(String incoming) {
        return incoming.length() > 32 ? DigestUtils.sha1Hex((String)incoming) : incoming;
    }
}

