/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.AbstractDataConverter;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.converter.TBDownlinkDataConverter;
import org.thingsboard.integration.api.data.DownlinkData;
import org.thingsboard.integration.api.data.IntegrationMetaData;
import org.thingsboard.script.api.js.JsInvokeService;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.msg.TbMsg;

public abstract class AbstractDownlinkDataConverter
extends AbstractDataConverter
implements TBDownlinkDataConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDownlinkDataConverter.class);

    public AbstractDownlinkDataConverter(JsInvokeService jsInvokeService, TbelInvokeService tbelInvokeService) {
        super(jsInvokeService, tbelInvokeService);
    }

    @Override
    public List<DownlinkData> convertDownLink(ConverterContext context, List<TbMsg> downLinkMsgs, IntegrationMetaData metadata) throws Exception {
        try {
            ArrayList<DownlinkData> result = new ArrayList<DownlinkData>();
            ArrayList<JsonNode> rawResults = new ArrayList<JsonNode>();
            long startTime = System.currentTimeMillis();
            for (TbMsg downLinkMsg : downLinkMsgs) {
                JsonNode rawResult = this.doConvertDownlink(downLinkMsg, metadata);
                rawResults.add(rawResult);
                if (rawResult.isArray()) {
                    for (JsonNode downlinkJson : rawResult) {
                        result.add(AbstractDownlinkDataConverter.parseDownlinkData(downlinkJson));
                    }
                    continue;
                }
                if (!rawResult.isObject()) continue;
                result.add(AbstractDownlinkDataConverter.parseDownlinkData(rawResult));
            }
            if (log.isTraceEnabled()) {
                log.trace("[{}][{}] Downlink conversion took {} ms.", new Object[]{this.configuration.getId(), this.configuration.getName(), System.currentTimeMillis() - startTime});
            }
            if (this.configuration.isDebugMode()) {
                this.persistDownlinkDebug(context, downLinkMsgs, rawResults, metadata);
            }
            return result;
        }
        catch (Exception e) {
            if (this.configuration.isDebugMode()) {
                this.persistDownlinkDebug(context, downLinkMsgs, metadata, e);
            }
            throw e;
        }
    }

    protected abstract JsonNode doConvertDownlink(TbMsg var1, IntegrationMetaData var2) throws Exception;

    public static DownlinkData parseDownlinkData(JsonNode src) {
        byte[] data;
        if (!src.isObject()) {
            throw new JsonParseException("Invalid Downlink json type: " + src.getNodeType());
        }
        if (!src.has("contentType")) {
            throw new JsonParseException("Downlink content type is not set!");
        }
        if (!src.has("data")) {
            throw new JsonParseException("Downlink data is not set!");
        }
        String contentType = src.get("contentType").asText();
        String strData = src.get("data").asText();
        switch (contentType) {
            case "JSON": 
            case "TEXT": {
                data = strData.getBytes(StandardCharsets.UTF_8);
                break;
            }
            case "BINARY": {
                data = Base64Utils.decodeFromString((String)strData);
                break;
            }
            default: {
                throw new JsonParseException("Unknown downlink content type " + contentType);
            }
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (src.has("metadata")) {
            JsonNode metadataElement = src.get("metadata");
            if (!metadataElement.isObject()) {
                throw new JsonParseException("Invalid downlink metadata format!");
            }
            metadataElement.fields().forEachRemaining(entry -> {
                JsonNode metadataValue = (JsonNode)entry.getValue();
                if (!metadataValue.isValueNode()) {
                    throw new JsonParseException("Invalid downlink metadata value format!");
                }
                metadata.put((String)entry.getKey(), metadataValue.asText());
            });
        }
        DownlinkData.DownlinkDataBuilder builder = DownlinkData.builder();
        builder.contentType(contentType);
        builder.data(data);
        builder.metadata(metadata);
        return builder.build();
    }

    private void persistDownlinkDebug(ConverterContext context, List<TbMsg> messages, List<JsonNode> rawResults, IntegrationMetaData metadata) {
        try {
            this.persistDebug(context, "Downlink", "JSON", this.msgListToJsonBytes(messages), "JSON", this.jsonListToJson(rawResults), this.metadataToJson(metadata), null);
        }
        catch (IOException e) {
            log.warn("Failed to persist downlink debug message");
        }
    }

    private void persistDownlinkDebug(ConverterContext context, List<TbMsg> messages, IntegrationMetaData metadata, Exception e) {
        try {
            this.persistDebug(context, "Downlink", "JSON", this.msgListToJsonBytes(messages), null, null, this.metadataToJson(metadata), e);
        }
        catch (IOException ex) {
            log.warn("Failed to persist downlink debug message", (Throwable)ex);
        }
    }

    private byte[] msgListToJsonBytes(List<TbMsg> messages) throws IOException {
        ArrayNode jsonArray = JacksonUtil.newArrayNode();
        for (TbMsg message : messages) {
            ObjectNode msgJson = JacksonUtil.newObjectNode();
            if (!StringUtils.isEmpty((String)message.getData())) {
                msgJson.set("msg", JacksonUtil.toJsonNode((String)message.getData()));
            } else {
                msgJson.put("msg", "");
            }
            msgJson.set("metadata", JacksonUtil.valueToTree((Object)message.getMetaData().getData()));
            msgJson.put("msgType", message.getType());
            jsonArray.add((JsonNode)msgJson);
        }
        return JacksonUtil.toString((Object)jsonArray).getBytes(StandardCharsets.UTF_8);
    }

    private byte[] jsonListToJson(List<JsonNode> jsons) throws IOException {
        ArrayNode jsonArray = JacksonUtil.newArrayNode();
        for (JsonNode json : jsons) {
            jsonArray.add(json);
        }
        return JacksonUtil.toString((Object)jsonArray).getBytes(StandardCharsets.UTF_8);
    }

    private String metadataToJson(IntegrationMetaData metaData) throws JsonProcessingException {
        return JacksonUtil.toString(metaData.getKvMap());
    }
}

