/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api;

import com.fasterxml.jackson.databind.JsonNode;
import io.netty.channel.EventLoopGroup;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.IntegrationRateLimitService;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.data.DownLinkMsg;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.server.common.data.event.IntegrationDebugEvent;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.gen.integration.AssetUplinkDataProto;
import org.thingsboard.server.gen.integration.DeviceUplinkDataProto;
import org.thingsboard.server.gen.integration.EntityViewDataProto;

public interface IntegrationContext {
    public String getServiceId();

    public ConverterContext getUplinkConverterContext();

    public ConverterContext getDownlinkConverterContext();

    public void processUplinkData(DeviceUplinkDataProto var1, IntegrationCallback<Void> var2);

    public void processUplinkData(AssetUplinkDataProto var1, IntegrationCallback<Void> var2);

    public void createEntityView(EntityViewDataProto var1, IntegrationCallback<Void> var2);

    public void processCustomMsg(TbMsg var1, IntegrationCallback<Void> var2);

    public void saveEvent(IntegrationDebugEvent var1, IntegrationCallback<Void> var2);

    public void saveRawDataEvent(String var1, String var2, String var3, JsonNode var4, IntegrationCallback<Void> var5);

    public EventLoopGroup getEventLoopGroup();

    public ScheduledExecutorService getScheduledExecutorService();

    public ExecutorService getExecutorService();

    public ExecutorService getCallBackExecutorService();

    public DownLinkMsg getDownlinkMsg(String var1);

    public DownLinkMsg putDownlinkMsg(IntegrationDownlinkMsg var1);

    public void removeDownlinkMsg(String var1);

    public boolean isClosed();

    public boolean isExceptionStackTraceEnabled();

    public void onUplinkMessageProcessed(boolean var1);

    public void onDownlinkMessageProcessed(boolean var1);

    public Optional<IntegrationRateLimitService> getRateLimitService();
}

