/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.controller;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.integration.api.IntegrationControllerApi;
import org.thingsboard.integration.api.IntegrationHttpMsgProcessor;
import org.thingsboard.integration.api.ThingsboardPlatformIntegration;
import org.thingsboard.server.common.data.integration.IntegrationType;

public abstract class AbstractIntegrationControllerApi
implements IntegrationControllerApi {
    private static final Logger log = LoggerFactory.getLogger(AbstractIntegrationControllerApi.class);

    @Override
    public <T> void process(IntegrationType type, String routingKey, DeferredResult<ResponseEntity> result, T msg) {
        this.process(type, routingKey, result, msg, (integration, tmpResult, tmpMsg) -> integration.process(tmpMsg));
    }

    @Override
    public <T> void process(IntegrationType type, String routingKey, DeferredResult<ResponseEntity> result, T msg, IntegrationHttpMsgProcessor<T> processor) {
        ListenableFuture<ThingsboardPlatformIntegration> integrationFuture = this.getIntegrationByRoutingKey(routingKey);
        DonAsynchron.withCallback(integrationFuture, integration -> {
            ThingsboardPlatformIntegration theIntegration = integration;
            if (AbstractIntegrationControllerApi.checkIntegrationPlatform(result, theIntegration, type)) {
                return;
            }
            processor.process(theIntegration, result, msg);
        }, failure -> {
            log.trace("[{}] Failed to fetch integration by routing key", (Object)routingKey, failure);
            result.setResult((Object)new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
        }, (Executor)this.getCallbackExecutor());
    }

    private static boolean checkIntegrationPlatform(DeferredResult<ResponseEntity> result, ThingsboardPlatformIntegration integration, IntegrationType type) {
        if (integration == null) {
            result.setResult((Object)new ResponseEntity(HttpStatus.NOT_FOUND));
            return true;
        }
        if (integration.getConfiguration().getType() != type) {
            result.setResult((Object)new ResponseEntity(HttpStatus.BAD_REQUEST));
            return true;
        }
        return false;
    }

    protected abstract Executor getCallbackExecutor();

    protected abstract ListenableFuture<ThingsboardPlatformIntegration> getIntegrationByRoutingKey(String var1);
}

