/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import org.springframework.util.Base64Utils;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.data.UplinkContentType;

public class ConvertUtil {
    public static String toDebugMessage(UplinkContentType messageType, byte[] message) {
        return ConvertUtil.toDebugMessage(messageType.name(), message);
    }

    public static String toDebugMessage(String messageType, byte[] message) {
        if (message == null) {
            return null;
        }
        switch (messageType) {
            case "JSON": 
            case "TEXT": {
                return new String(message, StandardCharsets.UTF_8);
            }
            case "BINARY": {
                return Base64Utils.encodeToString((byte[])message);
            }
        }
        throw new RuntimeException("Message type: " + messageType + " is not supported!");
    }

    public static void putJson(ObjectNode root, byte[] payload) {
        try {
            JsonNode payloadJson = JacksonUtil.fromBytes((byte[])payload);
            root.set("payload", payloadJson);
        }
        catch (IllegalArgumentException e) {
            root.put("payload", payload);
        }
    }
}

