/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import org.thingsboard.integration.api.converter.AbstractUplinkDataConverter;
import org.thingsboard.integration.api.converter.JSUplinkEvaluator;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.integration.api.util.LogSettingsComponent;
import org.thingsboard.js.api.JsInvokeService;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.EntityId;

public class JSUplinkDataConverter
extends AbstractUplinkDataConverter {
    private final JsInvokeService jsInvokeService;
    private final LogSettingsComponent logSettings;
    private JSUplinkEvaluator evaluator;

    @Override
    public void init(Converter configuration) {
        super.init(configuration);
        String decoder = configuration.getConfiguration().get("decoder").asText();
        this.evaluator = new JSUplinkEvaluator(configuration.getTenantId(), this.jsInvokeService, (EntityId)configuration.getId(), decoder);
    }

    @Override
    public void update(Converter configuration) {
        this.destroy();
        this.init(configuration);
    }

    @Override
    public void destroy() {
        if (this.evaluator != null) {
            this.evaluator.destroy();
        }
    }

    @Override
    public ListenableFuture<Object> doConvertUplink(byte[] data, UplinkMetaData metadata) throws Exception {
        return this.evaluator.execute(data, metadata);
    }

    @Override
    boolean isExceptionStackTraceEnabled() {
        return this.logSettings.isExceptionStackTraceEnabled();
    }

    @ConstructorProperties(value={"jsInvokeService", "logSettings"})
    public JSUplinkDataConverter(JsInvokeService jsInvokeService, LogSettingsComponent logSettings) {
        this.jsInvokeService = jsInvokeService;
        this.logSettings = logSettings;
    }
}

