/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import org.thingsboard.integration.api.converter.AbstractDownlinkDataConverter;
import org.thingsboard.integration.api.converter.JSDownlinkEvaluator;
import org.thingsboard.integration.api.data.IntegrationMetaData;
import org.thingsboard.integration.api.util.LogSettingsComponent;
import org.thingsboard.js.api.JsInvokeService;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.msg.TbMsg;

public class JSDownlinkDataConverter
extends AbstractDownlinkDataConverter {
    private final JsInvokeService jsInvokeService;
    private final LogSettingsComponent logSettings;
    private JSDownlinkEvaluator evaluator;

    @Override
    public void init(Converter configuration) {
        super.init(configuration);
        String encoder = configuration.getConfiguration().get("encoder").asText();
        this.evaluator = new JSDownlinkEvaluator(configuration.getTenantId(), this.jsInvokeService, (EntityId)configuration.getId(), encoder);
    }

    @Override
    public void update(Converter configuration) {
        this.destroy();
        this.init(configuration);
    }

    @Override
    public void destroy() {
        if (this.evaluator != null) {
            this.evaluator.destroy();
        }
    }

    @Override
    protected JsonNode doConvertDownlink(TbMsg msg, IntegrationMetaData metadata) throws Exception {
        return this.evaluator.execute(msg, metadata);
    }

    @Override
    boolean isExceptionStackTraceEnabled() {
        return this.logSettings.isExceptionStackTraceEnabled();
    }

    @ConstructorProperties(value={"jsInvokeService", "logSettings"})
    public JSDownlinkDataConverter(JsInvokeService jsInvokeService, LogSettingsComponent logSettings) {
        this.jsInvokeService = jsInvokeService;
        this.logSettings = logSettings;
    }
}

