/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.integration.api.converter.AbstractDataConverter;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.converter.TBUplinkDataConverter;
import org.thingsboard.integration.api.data.UplinkContentType;
import org.thingsboard.integration.api.data.UplinkData;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.gen.transport.TransportProtos;

public abstract class AbstractUplinkDataConverter
extends AbstractDataConverter
implements TBUplinkDataConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractUplinkDataConverter.class);
    private static final String DEFAULT_DEVICE_TYPE = "default";

    @Override
    public void init(Converter configuration) {
        this.configuration = configuration;
    }

    @Override
    public ListenableFuture<List<UplinkData>> convertUplink(ConverterContext context, byte[] data, UplinkMetaData metadata, ExecutorService callBackExecutorService) throws Exception {
        long startTime = System.currentTimeMillis();
        ListenableFuture<Object> convertFuture = this.doConvertUplink(data, metadata);
        ListenableFuture result = Futures.transform(convertFuture, convertResult -> {
            String rawResult = (String)convertResult;
            if (log.isTraceEnabled()) {
                log.trace("[{}][{}] Uplink conversion took {} ms.", new Object[]{this.configuration.getId(), this.configuration.getName(), System.currentTimeMillis() - startTime});
            }
            JsonElement element = new JsonParser().parse(rawResult);
            ArrayList<UplinkData> resultList = new ArrayList<UplinkData>();
            if (element.isJsonArray()) {
                for (JsonElement uplinkJson : element.getAsJsonArray()) {
                    resultList.add(this.parseUplinkData(uplinkJson.getAsJsonObject()));
                }
            } else if (element.isJsonObject()) {
                resultList.add(this.parseUplinkData(element.getAsJsonObject()));
            }
            if (this.configuration.isDebugMode()) {
                this.persistUplinkDebug(context, metadata.getContentType(), data, rawResult, metadata);
            }
            return resultList;
        }, (Executor)callBackExecutorService);
        DonAsynchron.withCallback((ListenableFuture)result, r -> {}, t -> {
            if (t instanceof Exception) {
                if (this.configuration.isDebugMode()) {
                    this.persistUplinkDebug(context, metadata.getContentType(), data, metadata, (Exception)t);
                }
            } else {
                log.warn("[{}][{}] Unhandled exception: ", new Object[]{this.configuration.getId(), this.configuration.getName(), t});
            }
        }, (Executor)callBackExecutorService);
        return result;
    }

    protected abstract ListenableFuture<Object> doConvertUplink(byte[] var1, UplinkMetaData var2) throws Exception;

    protected UplinkData parseUplinkData(JsonObject src) {
        boolean isAsset = this.getIsAssetAndVerify(src);
        UplinkData.UplinkDataBuilder builder = UplinkData.builder();
        builder.isAsset(isAsset);
        if (isAsset) {
            builder.assetName(src.get("assetName").getAsString());
            builder.assetType(src.get("assetType").getAsString());
            if (src.has("assetLabel")) {
                builder.assetLabel(src.get("assetLabel").getAsString());
            }
        } else {
            builder.deviceName(src.get("deviceName").getAsString());
            if (src.has("deviceType")) {
                builder.deviceType(src.get("deviceType").getAsString());
            } else {
                builder.deviceType(DEFAULT_DEVICE_TYPE);
            }
            if (src.has("deviceLabel")) {
                builder.deviceLabel(src.get("deviceLabel").getAsString());
            }
        }
        if (src.has("customerName")) {
            builder.customerName(src.get("customerName").getAsString());
        }
        if (src.has("groupName")) {
            builder.groupName(src.get("groupName").getAsString());
        }
        if (src.has("telemetry")) {
            builder.telemetry(this.parseTelemetry(src.get("telemetry")));
        }
        if (src.has("attributes")) {
            builder.attributesUpdate(this.parseAttributesUpdate(src.get("attributes")));
        }
        return builder.build();
    }

    private boolean getIsAssetAndVerify(JsonObject src) {
        boolean isAsset;
        boolean isDeviceNamePresent = src.has("deviceName");
        boolean isAssetNamePresent = src.has("assetName");
        boolean isAssetTypePresent = src.has("assetType");
        if (!isDeviceNamePresent && !isAssetNamePresent) {
            throw new JsonParseException("Either 'deviceName' or 'assetName' should be present in the converter output!");
        }
        if (isDeviceNamePresent && isAssetNamePresent) {
            throw new JsonParseException("Both 'deviceName' and 'assetName' can't be present in the converter output!");
        }
        if (isDeviceNamePresent) {
            isAsset = false;
        } else {
            if (!isAssetTypePresent) {
                throw new JsonParseException("Asset type is not set!");
            }
            isAsset = true;
        }
        return isAsset;
    }

    private TransportProtos.PostTelemetryMsg parseTelemetry(JsonElement src) {
        return JsonConverter.convertToTelemetryProto((JsonElement)src);
    }

    private TransportProtos.PostAttributeMsg parseAttributesUpdate(JsonElement src) {
        return JsonConverter.convertToAttributesProto((JsonElement)src);
    }

    private void persistUplinkDebug(ConverterContext context, UplinkContentType inMessageType, byte[] inMessage, String outMessage, UplinkMetaData metadata) {
        try {
            this.persistDebug(context, this.getTypeUplink(inMessage), inMessageType.name(), inMessage, "JSON", outMessage.getBytes(StandardCharsets.UTF_8), this.metadataToJson(metadata), null);
        }
        catch (JsonProcessingException e) {
            log.warn("Failed to persist uplink debug message");
        }
    }

    private void persistUplinkDebug(ConverterContext context, UplinkContentType inMessageType, byte[] inMessage, UplinkMetaData metadata, Exception e) {
        try {
            this.persistDebug(context, "Uplink", inMessageType.name(), inMessage, null, null, this.metadataToJson(metadata), e);
        }
        catch (JsonProcessingException ex) {
            log.warn("Failed to persist uplink debug message", (Throwable)ex);
        }
    }

    private String metadataToJson(UplinkMetaData metaData) throws JsonProcessingException {
        return this.mapper.writeValueAsString(metaData.getKvMap());
    }

    private String getTypeUplink(byte[] inMessage) throws JsonProcessingException {
        return inMessage != null && inMessage.length > 23 && Arrays.equals(Arrays.copyOfRange(inMessage, 1, 23), this.mapper.writeValueAsBytes((Object)"DevEUI_downlink_Sent")) ? "Downlink_Sent" : "Uplink";
    }
}

