/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.converter.TBDataConverter;
import org.thingsboard.integration.api.util.ConvertUtil;
import org.thingsboard.integration.api.util.ExceptionUtil;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.EntityId;

public abstract class AbstractDataConverter
implements TBDataConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataConverter.class);
    protected final ObjectMapper mapper = new ObjectMapper();
    protected Converter configuration;

    @Override
    public void init(Converter configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getName() {
        return this.configuration != null ? this.configuration.getName() : null;
    }

    protected String toString(Exception e) {
        return ExceptionUtil.toString(e, (EntityId)this.configuration.getId(), this.isExceptionStackTraceEnabled());
    }

    protected void persistDebug(ConverterContext context, String type, String inMessageType, byte[] inMessage, String outMessageType, byte[] outMessage, String metadata, Exception exception) {
        ObjectNode node = this.mapper.createObjectNode().put("server", context.getServiceId()).put("type", type).put("inMessageType", inMessageType).put("in", ConvertUtil.toDebugMessage(inMessageType, inMessage)).put("outMessageType", outMessageType).put("out", ConvertUtil.toDebugMessage(outMessageType, outMessage)).put("metadata", metadata);
        if (exception != null) {
            node = node.put("error", this.toString(exception));
        }
        context.saveEvent("DEBUG_CONVERTER", (JsonNode)node, new DebugEventCallback());
    }

    abstract boolean isExceptionStackTraceEnabled();

    private static class DebugEventCallback
    implements IntegrationCallback<Void> {
        private DebugEventCallback() {
        }

        @Override
        public void onSuccess(Void msg) {
            if (log.isDebugEnabled()) {
                log.debug("Event has been saved successfully!");
            }
        }

        @Override
        public void onError(Throwable e) {
            log.error("Failed to save the debug event!", e);
        }
    }
}

