/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.integration.api.converter.AbstractDataConverter;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.converter.TBUplinkDataConverter;
import org.thingsboard.integration.api.data.UplinkData;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.gen.transport.TransportProtos;

public abstract class AbstractUplinkDataConverter
extends AbstractDataConverter
implements TBUplinkDataConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractUplinkDataConverter.class);
    private static final String DEFAULT_DEVICE_TYPE = "default";

    @Override
    public void init(Converter configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<UplinkData> convertUplink(ConverterContext context, byte[] data, UplinkMetaData metadata) throws Exception {
        try {
            String rawResult = this.doConvertUplink(data, metadata);
            JsonElement element = new JsonParser().parse(rawResult);
            ArrayList<UplinkData> result = new ArrayList<UplinkData>();
            if (element.isJsonArray()) {
                for (JsonElement uplinkJson : element.getAsJsonArray()) {
                    result.add(this.parseUplinkData(uplinkJson.getAsJsonObject()));
                }
            } else if (element.isJsonObject()) {
                result.add(this.parseUplinkData(element.getAsJsonObject()));
            }
            if (this.configuration.isDebugMode()) {
                this.persistUplinkDebug(context, metadata.getContentType(), data, rawResult, metadata);
            }
            return result;
        }
        catch (Exception e) {
            if (this.configuration.isDebugMode()) {
                this.persistUplinkDebug(context, metadata.getContentType(), data, metadata, e);
            }
            throw e;
        }
    }

    protected abstract String doConvertUplink(byte[] var1, UplinkMetaData var2) throws Exception;

    protected UplinkData parseUplinkData(JsonObject src) {
        boolean isAsset = this.getIsAssetAndVerify(src);
        UplinkData.UplinkDataBuilder builder = UplinkData.builder();
        builder.isAsset(isAsset);
        if (isAsset) {
            builder.assetName(src.get("assetName").getAsString());
            builder.assetType(src.get("assetType").getAsString());
        } else {
            builder.deviceName(src.get("deviceName").getAsString());
            if (src.has("deviceType")) {
                builder.deviceType(src.get("deviceType").getAsString());
            } else {
                builder.deviceType(DEFAULT_DEVICE_TYPE);
            }
        }
        if (src.has("customerName")) {
            builder.customerName(src.get("customerName").getAsString());
        }
        if (src.has("groupName")) {
            builder.groupName(src.get("groupName").getAsString());
        }
        if (src.has("telemetry")) {
            builder.telemetry(this.parseTelemetry(src.get("telemetry")));
        }
        if (src.has("attributes")) {
            builder.attributesUpdate(this.parseAttributesUpdate(src.get("attributes")));
        }
        return builder.build();
    }

    private boolean getIsAssetAndVerify(JsonObject src) {
        boolean isAsset;
        boolean isDeviceNamePresent = src.has("deviceName");
        boolean isAssetNamePresent = src.has("assetName");
        boolean isAssetTypePresent = src.has("assetType");
        if (!isDeviceNamePresent && !isAssetNamePresent) {
            throw new JsonParseException("Either 'deviceName' or 'assetName' should be present in the converter output!");
        }
        if (isDeviceNamePresent && isAssetNamePresent) {
            throw new JsonParseException("Both 'deviceName' and 'assetName' can't be present in the converter output!");
        }
        if (isDeviceNamePresent) {
            isAsset = false;
        } else {
            if (!isAssetTypePresent) {
                throw new JsonParseException("Asset type is not set!");
            }
            isAsset = true;
        }
        return isAsset;
    }

    private TransportProtos.PostTelemetryMsg parseTelemetry(JsonElement src) {
        return JsonConverter.convertToTelemetryProto((JsonElement)src);
    }

    private TransportProtos.PostAttributeMsg parseAttributesUpdate(JsonElement src) {
        return JsonConverter.convertToAttributesProto((JsonElement)src);
    }

    private void persistUplinkDebug(ConverterContext context, String inMessageType, byte[] inMessage, String outMessage, UplinkMetaData metadata) {
        try {
            this.persistDebug(context, this.getTypeUplink(inMessage), inMessageType, inMessage, "JSON", outMessage.getBytes(StandardCharsets.UTF_8), this.metadataToJson(metadata), null);
        }
        catch (JsonProcessingException e) {
            log.warn("Failed to persist uplink debug message");
        }
    }

    private void persistUplinkDebug(ConverterContext context, String inMessageType, byte[] inMessage, UplinkMetaData metadata, Exception e) {
        try {
            this.persistDebug(context, "Uplink", inMessageType, inMessage, null, null, this.metadataToJson(metadata), e);
        }
        catch (JsonProcessingException ex) {
            log.warn("Failed to persist uplink debug message", (Throwable)ex);
        }
    }

    private String metadataToJson(UplinkMetaData metaData) throws JsonProcessingException {
        return this.mapper.writeValueAsString(metaData.getKvMap());
    }

    private String getTypeUplink(byte[] inMessage) throws JsonProcessingException {
        return inMessage != null && inMessage.length > 23 && Arrays.equals(Arrays.copyOfRange(inMessage, 1, 23), this.mapper.writeValueAsBytes((Object)"DevEUI_downlink_Sent")) ? "Downlink_Sent" : "Uplink";
    }
}

