/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.thingsboard.integration.api.converter.AbstractJSEvaluator;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.js.api.JsInvokeService;
import org.thingsboard.js.api.JsScriptType;
import org.thingsboard.server.common.data.id.EntityId;

public class JSUplinkEvaluator
extends AbstractJSEvaluator {
    private static final Logger log = LoggerFactory.getLogger(JSUplinkEvaluator.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public JSUplinkEvaluator(JsInvokeService jsInvokeService, EntityId entityId, String script) {
        super(jsInvokeService, entityId, JsScriptType.UPLINK_CONVERTER_SCRIPT, script);
    }

    public String execute(byte[] data, UplinkMetaData metadata) throws Exception {
        this.validateSuccessfulScriptLazyInit();
        String[] inArgs = JSUplinkEvaluator.prepareArgs(data, metadata);
        return this.jsInvokeService.invokeFunction(this.scriptId, new Object[]{inArgs[0], inArgs[1]}).get().toString();
    }

    private static String[] prepareArgs(byte[] data, UplinkMetaData metadata) {
        try {
            String[] args = new String[]{Base64Utils.encodeToString((byte[])data), mapper.writeValueAsString(metadata.getKvMap())};
            return args;
        }
        catch (Throwable th) {
            throw new IllegalArgumentException("Cannot bind js args", th);
        }
    }
}

