/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutionException;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.integration.api.converter.AbstractJSEvaluator;
import org.thingsboard.integration.api.data.IntegrationMetaData;
import org.thingsboard.js.api.JsInvokeService;
import org.thingsboard.js.api.JsScriptType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.msg.TbMsg;

public class JSDownlinkEvaluator
extends AbstractJSEvaluator {
    private static final Logger log = LoggerFactory.getLogger(JSDownlinkEvaluator.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public JSDownlinkEvaluator(JsInvokeService jsInvokeService, EntityId entityId, String script) {
        super(jsInvokeService, entityId, JsScriptType.DOWNLINK_CONVERTER_SCRIPT, script);
    }

    public JsonNode execute(TbMsg msg, IntegrationMetaData metadata) throws ScriptException {
        try {
            this.validateSuccessfulScriptLazyInit();
            String[] inArgs = JSDownlinkEvaluator.prepareArgs(msg, metadata);
            String eval = this.jsInvokeService.invokeFunction(this.scriptId, new Object[]{inArgs[0], inArgs[1], inArgs[2], inArgs[3]}).get().toString();
            return mapper.readTree(eval);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ScriptException) {
                throw (ScriptException)e.getCause();
            }
            throw new ScriptException("Failed to execute js script: " + e.getMessage());
        }
        catch (Exception e) {
            throw new ScriptException("Failed to execute js script: " + e.getMessage());
        }
    }

    private static String[] prepareArgs(TbMsg msg, IntegrationMetaData metadata) {
        try {
            String[] args = new String[]{msg.getData() != null ? msg.getData() : "", mapper.writeValueAsString((Object)msg.getMetaData().getData()), msg.getType(), mapper.writeValueAsString(metadata.getKvMap())};
            return args;
        }
        catch (Throwable th) {
            throw new IllegalArgumentException("Cannot bind js args", th);
        }
    }
}

