/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.js.api.JsInvokeService;
import org.thingsboard.js.api.JsScriptType;
import org.thingsboard.server.common.data.id.EntityId;

public abstract class AbstractJSEvaluator {
    private static final Logger log = LoggerFactory.getLogger(AbstractJSEvaluator.class);
    protected final JsInvokeService jsInvokeService;
    private final JsScriptType scriptType;
    private final String script;
    protected final EntityId entityId;
    protected volatile UUID scriptId;
    private volatile boolean isErrorScript = false;

    public AbstractJSEvaluator(JsInvokeService jsInvokeService, EntityId entityId, JsScriptType scriptType, String script) {
        this.jsInvokeService = jsInvokeService;
        this.scriptType = scriptType;
        this.script = script;
        this.entityId = entityId;
    }

    public void destroy() {
        if (this.scriptId != null) {
            this.jsInvokeService.release(this.scriptId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateSuccessfulScriptLazyInit() {
        if (this.scriptId != null) {
            return;
        }
        if (this.isErrorScript) {
            throw new IllegalArgumentException("Can't compile uplink converter script ");
        }
        AbstractJSEvaluator abstractJSEvaluator = this;
        synchronized (abstractJSEvaluator) {
            if (this.scriptId == null) {
                try {
                    this.scriptId = (UUID)this.jsInvokeService.eval(this.scriptType, this.script, new String[0]).get();
                }
                catch (Exception e) {
                    this.isErrorScript = true;
                    throw new IllegalArgumentException("Can't compile script: " + e.getMessage(), e);
                }
            }
        }
    }
}

