/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.converter.TBDataConverter;
import org.thingsboard.server.common.data.converter.Converter;

public abstract class AbstractDataConverter
implements TBDataConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataConverter.class);
    protected final ObjectMapper mapper = new ObjectMapper();
    protected Converter configuration;

    @Override
    public void init(Converter configuration) {
        this.configuration = configuration;
    }

    protected String toString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private String convertToString(String messageType, byte[] message) {
        if (message == null) {
            return null;
        }
        switch (messageType) {
            case "JSON": 
            case "TEXT": {
                return new String(message, StandardCharsets.UTF_8);
            }
            case "BINARY": {
                return Base64Utils.encodeToString((byte[])message);
            }
        }
        throw new RuntimeException("Message type: " + messageType + " is not supported!");
    }

    protected void persistDebug(ConverterContext context, String type, String inMessageType, byte[] inMessage, String outMessageType, byte[] outMessage, String metadata, Exception exception) {
        ObjectNode node = this.mapper.createObjectNode().put("server", context.getServerAddress().toString()).put("type", type).put("inMessageType", inMessageType).put("in", this.convertToString(inMessageType, inMessage)).put("outMessageType", outMessageType).put("out", this.convertToString(outMessageType, outMessage)).put("metadata", metadata);
        if (exception != null) {
            node = node.put("error", this.toString(exception));
        }
        context.saveEvent("DEBUG_CONVERTER", (JsonNode)node, new DebugEventCallback());
    }

    private static class DebugEventCallback
    implements IntegrationCallback<Void> {
        private DebugEventCallback() {
        }

        @Override
        public void onSuccess(Void msg) {
            if (log.isDebugEnabled()) {
                log.debug("Event has been saved successfully!");
            }
        }

        @Override
        public void onError(Throwable e) {
            log.error("Failed to save the debug event!", e);
        }
    }
}

