/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import org.thingsboard.integration.api.converter.AbstractUplinkDataConverter;
import org.thingsboard.integration.api.converter.JSUplinkEvaluator;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.js.api.JsInvokeService;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.EntityId;

public class JSUplinkDataConverter
extends AbstractUplinkDataConverter {
    private final JsInvokeService jsInvokeService;
    private JSUplinkEvaluator evaluator;

    public JSUplinkDataConverter(JsInvokeService jsInvokeService) {
        this.jsInvokeService = jsInvokeService;
    }

    @Override
    public void init(Converter configuration) {
        super.init(configuration);
        String decoder = configuration.getConfiguration().get("decoder").asText();
        this.evaluator = new JSUplinkEvaluator(this.jsInvokeService, (EntityId)configuration.getId(), decoder);
    }

    @Override
    public void update(Converter configuration) {
        this.destroy();
        this.init(configuration);
    }

    @Override
    public void destroy() {
        if (this.evaluator != null) {
            this.evaluator.destroy();
        }
    }

    @Override
    public String doConvertUplink(byte[] data, UplinkMetaData metadata) throws Exception {
        return this.evaluator.execute(data, metadata);
    }
}

