/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.integration.api.converter.AbstractDataConverter;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.converter.TBUplinkDataConverter;
import org.thingsboard.integration.api.data.UplinkData;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.gen.transport.PostAttributeMsg;
import org.thingsboard.server.gen.transport.PostTelemetryMsg;

public abstract class AbstractUplinkDataConverter
extends AbstractDataConverter
implements TBUplinkDataConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractUplinkDataConverter.class);

    @Override
    public void init(Converter configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<UplinkData> convertUplink(ConverterContext context, byte[] data, UplinkMetaData metadata) throws Exception {
        try {
            String rawResult = this.doConvertUplink(data, metadata);
            JsonElement element = new JsonParser().parse(rawResult);
            ArrayList<UplinkData> result = new ArrayList<UplinkData>();
            if (element.isJsonArray()) {
                for (JsonElement uplinkJson : element.getAsJsonArray()) {
                    result.add(this.parseUplinkData(uplinkJson.getAsJsonObject()));
                }
            } else if (element.isJsonObject()) {
                result.add(this.parseUplinkData(element.getAsJsonObject()));
            }
            if (this.configuration.isDebugMode()) {
                this.persistUplinkDebug(context, metadata.getContentType(), data, rawResult, metadata);
            }
            return result;
        }
        catch (Exception e) {
            if (this.configuration.isDebugMode()) {
                this.persistUplinkDebug(context, metadata.getContentType(), data, metadata, e);
            }
            throw e;
        }
    }

    protected abstract String doConvertUplink(byte[] var1, UplinkMetaData var2) throws Exception;

    protected UplinkData parseUplinkData(JsonObject src) {
        if (!src.has("deviceName")) {
            throw new JsonParseException("Device name is not set!");
        }
        if (!src.has("deviceType")) {
            throw new JsonParseException("Device type is not set!");
        }
        UplinkData.UplinkDataBuilder builder = UplinkData.builder();
        builder.deviceName(src.get("deviceName").getAsString());
        builder.deviceType(src.get("deviceType").getAsString());
        if (src.has("customerName")) {
            builder.customerName(src.get("customerName").getAsString());
        }
        if (src.has("telemetry")) {
            builder.telemetry(this.parseTelemetry(src.get("telemetry")));
        }
        if (src.has("attributes")) {
            builder.attributesUpdate(this.parseAttributesUpdate(src.get("attributes")));
        }
        return builder.build();
    }

    private PostTelemetryMsg parseTelemetry(JsonElement src) {
        return JsonConverter.convertToTelemetryProto((JsonElement)src);
    }

    private PostAttributeMsg parseAttributesUpdate(JsonElement src) {
        return JsonConverter.convertToAttributesProto((JsonElement)src);
    }

    private void persistUplinkDebug(ConverterContext context, String inMessageType, byte[] inMessage, String outMessage, UplinkMetaData metadata) {
        try {
            this.persistDebug(context, "Uplink", inMessageType, inMessage, "JSON", outMessage.getBytes(StandardCharsets.UTF_8), this.metadataToJson(metadata), null);
        }
        catch (JsonProcessingException e) {
            log.warn("Failed to persist uplink debug message");
        }
    }

    private void persistUplinkDebug(ConverterContext context, String inMessageType, byte[] inMessage, UplinkMetaData metadata, Exception e) {
        try {
            this.persistDebug(context, "Uplink", inMessageType, inMessage, null, null, this.metadataToJson(metadata), e);
        }
        catch (JsonProcessingException ex) {
            log.warn("Failed to persist uplink debug message", (Throwable)ex);
        }
    }

    private String metadataToJson(UplinkMetaData metaData) throws JsonProcessingException {
        return this.mapper.writeValueAsString(metaData.getKvMap());
    }
}

