/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.integration.api;

import com.datastax.driver.core.utils.UUIDs;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.IntegrationContext;
import org.thingsboard.integration.api.IntegrationStatistics;
import org.thingsboard.integration.api.TbIntegrationInitParams;
import org.thingsboard.integration.api.ThingsboardPlatformIntegration;
import org.thingsboard.integration.api.converter.TBDownlinkDataConverter;
import org.thingsboard.integration.api.converter.TBUplinkDataConverter;
import org.thingsboard.integration.api.data.DownlinkData;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.integration.api.data.UplinkData;
import org.thingsboard.integration.api.data.UplinkMetaData;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.gen.integration.DeviceUplinkDataProto;
import org.thingsboard.server.gen.integration.EntityViewDataProto;

public abstract class AbstractIntegration<T>
implements ThingsboardPlatformIntegration<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractIntegration.class);
    protected final ObjectMapper mapper = new ObjectMapper();
    protected Integration configuration;
    protected IntegrationContext context;
    protected TBUplinkDataConverter uplinkConverter;
    protected TBDownlinkDataConverter downlinkConverter;
    protected UplinkMetaData metadataTemplate;
    protected IntegrationStatistics integrationStatistics;

    @Override
    public void init(TbIntegrationInitParams params) throws Exception {
        this.configuration = params.getConfiguration();
        this.context = params.getContext();
        this.uplinkConverter = params.getUplinkConverter();
        this.downlinkConverter = params.getDownlinkConverter();
        HashMap<String, String> mdMap = new HashMap<String, String>();
        mdMap.put("integrationName", this.configuration.getName());
        JsonNode metadata = this.configuration.getConfiguration().get("metadata");
        Iterator it = metadata.fields();
        while (it.hasNext()) {
            Map.Entry md = (Map.Entry)it.next();
            mdMap.put((String)md.getKey(), ((JsonNode)md.getValue()).asText());
        }
        this.metadataTemplate = new UplinkMetaData(this.getUplinkContentType(), mdMap);
        this.integrationStatistics = new IntegrationStatistics();
    }

    protected String getUplinkContentType() {
        return "JSON";
    }

    @Override
    public void update(TbIntegrationInitParams params) throws Exception {
        this.init(params);
    }

    @Override
    public Integration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void validateConfiguration(Integration configuration, boolean allowLocalNetworkHosts) {
        if (configuration == null || configuration.getConfiguration() == null) {
            throw new IllegalArgumentException("Integration configuration is empty!");
        }
        this.doValidateConfiguration(configuration.getConfiguration(), allowLocalNetworkHosts);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void onDownlinkMsg(IntegrationDownlinkMsg msg) {
    }

    @Override
    public IntegrationStatistics popStatistics() {
        IntegrationStatistics statistics = this.integrationStatistics;
        this.integrationStatistics = new IntegrationStatistics();
        return statistics;
    }

    protected void doValidateConfiguration(JsonNode configuration, boolean allowLocalNetworkHosts) {
    }

    protected void processUplinkData(IntegrationContext context, UplinkData data) {
        context.processUplinkData(DeviceUplinkDataProto.newBuilder().setDeviceName(data.getDeviceName()).setDeviceType(data.getDeviceType()).setPostTelemetryMsg(data.getTelemetry()).setPostAttributesMsg(data.getAttributesUpdate()).build(), null);
    }

    protected void processEntityViewCreation(IntegrationContext context, UplinkData data, String viewName, String viewType) {
        context.processEntityViewCreation(EntityViewDataProto.newBuilder().setViewName(viewName).setViewType(viewType).setDeviceName(data.getDeviceName()).setDeviceType(data.getDeviceType()).build(), null);
    }

    protected static boolean isLocalNetworkHost(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            if (address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress()) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unable to resolve provided hostname: " + host);
        }
        return false;
    }

    protected void persistDebug(IntegrationContext context, String type, String messageType, String message, String status, Exception exception) {
        ObjectNode node = this.mapper.createObjectNode().put("server", context.getServerAddress().toString()).put("type", type).put("messageType", messageType).put("message", message).put("status", status);
        if (exception != null) {
            node = node.put("error", this.toString(exception));
        }
        context.saveEvent("DEBUG_INTEGRATION", UUIDs.timeBased().toString(), (JsonNode)node, new DebugEventCallback());
    }

    private String toString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    protected List<UplinkData> convertToUplinkDataList(IntegrationContext context, byte[] data, UplinkMetaData md) throws Exception {
        try {
            return this.uplinkConverter.convertUplink(context.getUplinkConverterContext(), data, md);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Failed to apply uplink data converter function for data: {} and metadata: {}", new Object[]{this.configuration.getId(), this.configuration.getName(), Base64Utils.encodeToString((byte[])data), md});
            }
            throw e;
        }
    }

    protected void reportDownlinkOk(IntegrationContext context, DownlinkData data) {
        this.integrationStatistics.incMessagesProcessed();
        if (this.configuration.isDebugMode()) {
            try {
                ObjectNode json = this.mapper.createObjectNode();
                if (data.getMetadata() != null && !data.getMetadata().isEmpty()) {
                    json.set("metadata", this.mapper.valueToTree(data.getMetadata()));
                }
                json.set("payload", this.getDownlinkPayloadJson(data));
                this.persistDebug(context, "Downlink", "JSON", this.mapper.writeValueAsString((Object)json), this.downlinkConverter != null ? "OK" : "FAILURE", null);
            }
            catch (Exception e) {
                log.warn("Failed to persist debug message", (Throwable)e);
            }
        }
    }

    protected void reportDownlinkError(IntegrationContext context, TbMsg msg, String status, Exception exception) {
        if (!status.equals("OK")) {
            this.integrationStatistics.incErrorsOccurred();
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Failed to apply downlink data converter function for data: {} and metadata: {}", new Object[]{this.configuration.getId(), this.configuration.getName(), msg.getData(), msg.getMetaData()});
            }
            if (this.configuration.isDebugMode()) {
                try {
                    this.persistDebug(context, "Downlink", "JSON", this.mapper.writeValueAsString((Object)msg), status, exception);
                }
                catch (Exception e) {
                    log.warn("Failed to persist debug message", (Throwable)e);
                }
            }
        }
    }

    protected JsonNode getDownlinkPayloadJson(DownlinkData data) throws IOException {
        String contentType = data.getContentType();
        if ("JSON".equals(contentType)) {
            return this.mapper.readTree(data.getData());
        }
        if ("TEXT".equals(contentType)) {
            return new TextNode(new String(data.getData(), StandardCharsets.UTF_8));
        }
        return new TextNode(Base64Utils.encodeToString((byte[])data.getData()));
    }

    protected <T> void logDownlink(IntegrationContext context, String updateType, T msg) {
        if (this.configuration.isDebugMode()) {
            try {
                this.persistDebug(context, updateType, "JSON", this.mapper.writeValueAsString(msg), this.downlinkConverter != null ? "OK" : "FAILURE", null);
            }
            catch (Exception e) {
                log.warn("Failed to persist debug message", (Throwable)e);
            }
        }
    }

    private static class DebugEventCallback
    implements IntegrationCallback<Void> {
        private DebugEventCallback() {
        }

        @Override
        public void onSuccess(Void msg) {
            if (log.isDebugEnabled()) {
                log.debug("Event has been saved successfully!");
            }
        }

        @Override
        public void onError(Throwable e) {
            log.error("Failed to save the debug event!", e);
        }
    }
}

